/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool;

import com.google.common.io.ByteStreams;
import com.jme3.app.Application;
import com.jme3.app.BasicProfilerState;
import com.jme3.app.DebugKeysAppState;
import com.jme3.app.SimpleApplication;
import com.jme3.app.StatsAppState;
import com.jme3.app.state.AppState;
import com.jme3.app.state.ScreenshotAppState;
import com.jme3.math.ColorRGBA;
import com.jme3.system.AppSettings;
import com.simsilica.fx.LightingState;
import com.simsilica.fx.sky.SkySettingsState;
import com.simsilica.fx.sky.SkyState;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.HAlignment;
import com.simsilica.lemur.Insets3f;
import com.simsilica.lemur.OptionPanelState;
import com.simsilica.lemur.component.QuadBackgroundComponent;
import com.simsilica.lemur.input.InputMapper;
import com.simsilica.lemur.style.Attributes;
import com.simsilica.lemur.style.BaseStyles;
import com.simsilica.lemur.style.Styles;
import com.simsilica.state.CameraState;
import com.simsilica.state.CommandConsoleState;
import com.simsilica.state.DebugHudState;
import com.simsilica.state.MemoryDebugState;
import com.simsilica.tool.AnimationState;
import com.simsilica.tool.ArmatureViewState;
import com.simsilica.tool.ClothingState;
import com.simsilica.tool.ColliderViewState;
import com.simsilica.tool.DebugNormalsState;
import com.simsilica.tool.EnvironmentSettingsState;
import com.simsilica.tool.FileMenuState;
import com.simsilica.tool.GridState;
import com.simsilica.tool.HelpState;
import com.simsilica.tool.MainAppFunctions;
import com.simsilica.tool.MainMenuState;
import com.simsilica.tool.MobilityState;
import com.simsilica.tool.ModelInfoState;
import com.simsilica.tool.OrbitCameraFunctions;
import com.simsilica.tool.OrbitCameraState;
import com.simsilica.tool.PhysicsState;
import com.simsilica.tool.RigViewState;
import com.simsilica.tool.RiggerConfig;
import com.simsilica.tool.ToolState;
import com.simsilica.util.LogAdapter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Rigger
extends SimpleApplication {
    static Logger log = LoggerFactory.getLogger(Rigger.class);
    private static final String[] SAMPLES = new String[]{"/models/mythruna-girl/female-parts-hair1-gray-DiffuseMap.png", "/models/mythruna-girl/female-parts-hair1-gray-NormalMap.png", "/models/mythruna-girl/femaleSkin-1024.png", "/models/mythruna-girl/femaleSkin-mrh-1.png", "/models/mythruna-girl/femaleSkin-mrh-1024.png", "/models/mythruna-girl/femaleSkin-norms.png", "/models/mythruna-girl/Grid-x.png", "/models/mythruna-girl/license.txt", "/models/mythruna-girl/mythruna-girl.rig.j3o", "/Templates/boots.clothing", "/Templates/female-underwear1.clothing", "/Templates/pants-low.clothing", "/Templates/pants-short.clothing", "/Templates/pants.clothing", "/Templates/shirt-long.clothing", "/Templates/shirt-short.clothing", "/Templates/underwear1.clothing", "/Templates/underwear2.clothing", "/Templates/underwear3.clothing", "/Templates/vest-short.clothing", "/Templates/vest.clothing", "/textures/BaseSkin.png", "/textures/blue-plaid.png", "/textures/burlap-normals.png", "/textures/chainmail1024-normals.png", "/textures/cloth1-normals.png", "/textures/cross-hatch-grid.png", "/textures/green-plaid.png", "/textures/heavy-weave-normals.png", "/textures/leather-gradient.jpg", "/textures/leather-normals.png", "/textures/medium-steel.jpg", "/textures/metal-base.png", "/textures/red-plaid.png", "/textures/ROCK6-norm.jpg", "/textures/rust-base.png", "/textures/rust-mr.png", "/textures/rust-normals.png", "/textures/shapes.png", "/textures/weave4-normals.png", "/mythruna-girl.rig"};

    public static void main(String ... args) throws Exception {
        LogAdapter.initialize();
        RiggerConfig config = RiggerConfig.getInstance();
        for (String resource : SAMPLES) {
            File target = config.getFile(resource);
            if (target.exists()) continue;
            log.info("Extracting:" + resource + " to:" + target);
            if (!target.getParentFile().exists()) {
                target.getParentFile().mkdirs();
            }
            try (InputStream in = Rigger.class.getResourceAsStream("/samples" + resource);){
                FileOutputStream out = new FileOutputStream(target);
                ByteStreams.copy((InputStream)in, (OutputStream)out);
            }
        }
        Rigger main = new Rigger();
        AppSettings settings = new AppSettings(true);
        settings.setWidth(1280);
        settings.setHeight(720);
        settings.setVSync(true);
        settings.setGammaCorrection(false);
        settings.load("MOSS-Rigger Tool");
        settings.load("MOSS-Rigger Tool - " + RiggerConfig.getInstance().getProjectDir());
        settings.setTitle("MOSS-Rigger Tool - " + RiggerConfig.getInstance().getProjectDir());
        settings.setUseJoysticks(true);
        main.setSettings(settings);
        main.start();
    }

    public Rigger() {
        super(new AppState[]{new StatsAppState(), new DebugKeysAppState(), new BasicProfilerState(false), new DebugHudState(), new MemoryDebugState(), new DebugNormalsState(), new CameraState(45.0f, 0.01f, 1000.0f), new OptionPanelState(), new OrbitCameraState(3.5f), new LightingState(), new SkyState(true), new SkySettingsState(), new MainMenuState("Rigger"), new FileMenuState(), new EnvironmentSettingsState(), new GridState(), new ToolState(), new RigViewState(), new ColliderViewState(), new ArmatureViewState(), new AnimationState(), new PhysicsState(), new MobilityState(), new ClothingState(), new ModelInfoState(), new CommandConsoleState(), new HelpState(), new ScreenshotAppState("", System.currentTimeMillis())});
    }

    public void simpleInitApp() {
        this.setPauseOnLostFocus(false);
        this.setDisplayFps(false);
        this.setDisplayStatView(false);
        GuiGlobals.initialize((Application)this);
        GuiGlobals globals = GuiGlobals.getInstance();
        BaseStyles.loadGlassStyle();
        globals.getStyles().setDefaultStyle("glass");
        InputMapper inputMapper = globals.getInputMapper();
        MainMenuState.initializeDefaultMappings((InputMapper)inputMapper);
        OrbitCameraFunctions.initializeDefaultMappings((InputMapper)inputMapper);
        MainAppFunctions.initializeDefaultMappings(inputMapper);
        Styles styles = globals.getStyles();
        Attributes attrs = styles.getSelector(DebugHudState.CONTAINER_ID, "glass");
        attrs.set("background", null);
        attrs = styles.getSelector(DebugHudState.NAME_ID, "glass");
        attrs.set("color", (Object)ColorRGBA.White);
        attrs.set("background", (Object)new QuadBackgroundComponent(new ColorRGBA(0.0f, 0.0f, 0.0f, 0.5f)));
        attrs.set("textHAlignment", (Object)HAlignment.Right);
        attrs.set("insets", (Object)new Insets3f(0.0f, 0.0f, 0.0f, 0.0f));
        attrs = styles.getSelector(DebugHudState.VALUE_ID, "glass");
        attrs.set("color", (Object)ColorRGBA.White);
        attrs.set("background", (Object)new QuadBackgroundComponent(new ColorRGBA(0.0f, 0.0f, 0.0f, 0.5f)));
        attrs.set("insets", (Object)new Insets3f(0.0f, 0.0f, 0.0f, 0.0f));
        globals.setCursorEventsEnabled(false);
        SkyState sky = (SkyState)this.stateManager.getState(SkyState.class);
        sky.getGroundColor().set(0.3f, 0.5f, 0.1f, 1.0f);
        LightingState lighting = (LightingState)this.stateManager.getState(LightingState.class);
        lighting.setSunColor(ColorRGBA.White.clone());
        lighting.setAmbient(ColorRGBA.White.clone());
    }
}

