/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RiggerConfig {
    public static final String CONFIG_FILE = "rigger.config";
    public static final String DEFAULT_PROJECT_DIR = ".";
    public static final String DEFAULT_BINARY_DIR = "binaries";
    public static final String DEFAULT_RIG_BINARY_DIR = "binaries/rigs";
    public static final String DEFAULT_MODEL_BINARY_DIR = "binaries/Models";
    static Logger log = LoggerFactory.getLogger(RiggerConfig.class);
    private String projectDir;
    private String binaryDir;
    private String rigBinaryDir;
    private String modelBinaryDir;
    private static RiggerConfig instance;

    protected void initializeDefaults() {
        this.projectDir = DEFAULT_PROJECT_DIR;
    }

    protected void upgrade() {
        File f;
        if (this.rigBinaryDir == null) {
            this.rigBinaryDir = this.binaryDir != null ? this.modelBinaryDir + "/rigs" : DEFAULT_RIG_BINARY_DIR;
            f = this.getFile(this.rigBinaryDir);
            if (!f.exists()) {
                f.mkdirs();
            }
        }
        if (this.modelBinaryDir == null) {
            this.modelBinaryDir = this.binaryDir != null ? this.modelBinaryDir + "/Models" : DEFAULT_MODEL_BINARY_DIR;
            f = this.getFile(this.modelBinaryDir);
            if (!f.exists()) {
                f.mkdirs();
            }
        }
    }

    public File getProjectDir() {
        return new File(this.projectDir);
    }

    public File getRigBinaryDir() {
        return this.getFile(this.rigBinaryDir);
    }

    public File getModelBinaryDir() {
        return this.getFile(this.modelBinaryDir);
    }

    public File getFile(String name) {
        return new File(this.getProjectDir(), name);
    }

    public static RiggerConfig getInstance() {
        if (instance == null) {
            try {
                instance = RiggerConfig.load(new File(CONFIG_FILE));
                instance.upgrade();
            }
            catch (Exception e) {
                log.error("Error loading config file.  Initializing defaults", (Throwable)e);
            }
        }
        if (instance == null) {
            instance = new RiggerConfig();
            instance.initializeDefaults();
            File f = new File(CONFIG_FILE);
            if (!f.exists()) {
                RiggerConfig.store(instance, new File(CONFIG_FILE));
            }
        }
        return instance;
    }

    public static RiggerConfig load(File f) {
        GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting();
        Gson gson = gsonBuilder.create();
        try {
            String json = Files.toString((File)f, (Charset)Charsets.UTF_8);
            return (RiggerConfig)gson.fromJson(json, RiggerConfig.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading:" + f, e);
        }
    }

    public static void store(RiggerConfig config, File f) {
        GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting();
        Gson gson = gsonBuilder.create();
        try {
            log.info("Storing:" + f);
            String json = gson.toJson((Object)config);
            Files.write((CharSequence)json, (File)f, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Error storing:" + f, e);
        }
    }
}

