/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool;

import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.texture.Image;
import com.jme3.texture.image.ImageRaster;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.Direction;
import com.simsilica.tool.ImageSource;
import com.simsilica.tool.ImageSources;
import com.simsilica.tool.ImageUtils;
import com.simsilica.tool.SwatchShape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwatchIndex {
    static Logger log = LoggerFactory.getLogger(SwatchIndex.class);
    private List<SwatchShape> baseShapes = new ArrayList<SwatchShape>();
    private List<SwatchData> shapes = new ArrayList<SwatchData>();
    private Image shapeAtlas = ImageUtils.createImage(Image.Format.ABGR8, 512, 512);
    private ImageRaster shapeRaster = ImageRaster.create((Image)this.shapeAtlas);
    private ImageSource shapeSource = ImageSources.raster(this.shapeRaster);

    public List<SwatchShape> getBaseShapes() {
        return this.baseShapes;
    }

    public SwatchShape getBaseShape(int index) {
        return this.baseShapes.get(index);
    }

    public ImageSource getShapeSource(int index) {
        return this.shapes.get(index).source;
    }

    public List<SwatchData> getSwatchData() {
        return Collections.unmodifiableList(this.shapes);
    }

    public SwatchData getSwatchData(int index) {
        return this.shapes.get(index);
    }

    public Vec3i getShapeCell(int index) {
        return this.shapes.get(index).cell;
    }

    public SwatchShape add(SwatchShape shape) {
        this.baseShapes.add(shape);
        return shape;
    }

    public void buildVariants(ImageSource sourceAtlas) {
        for (SwatchShape shape : this.baseShapes) {
            List<Direction> dirs = shape.getEdges();
            int dirMask = SwatchShape.dirsToMask(dirs);
            for (int i = 0; i < 16; ++i) {
                if ((i & dirMask) != i) continue;
                SwatchData data = new SwatchData(shape, i);
                shape.setVariantIndex(i, this.shapes.size());
                this.shapes.add(data);
            }
        }
        log.info("Total shapes:" + this.shapes.size());
        for (int i = 0; i < this.shapes.size(); ++i) {
            SwatchData data = this.shapes.get(i);
            Vec3i cell = data.baseShape.getSourceCell();
            int forcedMask = data.baseShape.getForcedMask();
            ImageSource<ImageSource> source = ImageSources.subimage(sourceAtlas, cell.x * 32, cell.y * 32, 32, 32);
            int xCell = i % 16;
            int yCell = i / 16;
            data.cell = new Vec3i(xCell, yCell, 0);
            ImageUtils.paint(source, this.shapeRaster, xCell * 32, yCell * 32);
            this.calculateNormals(this.shapeRaster, xCell * 32, yCell * 32, data.dirMask | forcedMask);
            data.source = ImageSources.subimage(this.shapeSource, xCell * 32, yCell * 32, 32, 32);
        }
    }

    protected void calculateNormals(ImageRaster raster, int xBase, int yBase, int dirMask) {
        int i;
        Vector3f[][] normals = new Vector3f[32][32];
        int[][] counts = new int[raster.getWidth()][raster.getHeight()];
        float intensity = 2.0f;
        for (int j = 0; j < 32; ++j) {
            Vector3f normal;
            float delta;
            float alpha;
            int i2;
            int y = j;
            float last = (dirMask & 8) != 0 ? 0.0f : raster.getPixel((int)(xBase + 0), (int)(yBase + y)).a;
            Vector3f lastNormal = null;
            for (i2 = 0; i2 < 32; ++i2) {
                alpha = raster.getPixel((int)(xBase + i2), (int)(yBase + y)).a;
                if (alpha > 0.0f) {
                    delta = alpha - last;
                    if ((double)Math.abs(delta) < 0.001 && lastNormal != null) {
                        normal = lastNormal;
                        lastNormal = null;
                    } else {
                        lastNormal = normal = new Vector3f(-delta * intensity, 0.0f, 1.0f - Math.abs(delta)).normalizeLocal();
                    }
                    if (normals[i2][j] == null) {
                        normals[i2][j] = normal.clone();
                    } else {
                        normals[i2][j].addLocal(normal);
                    }
                    int[] nArray = counts[i2];
                    int n = j;
                    nArray[n] = nArray[n] + 1;
                }
                last = alpha;
            }
            last = (dirMask & 4) != 0 ? 0.0f : raster.getPixel((int)(xBase + 31), (int)(yBase + y)).a;
            lastNormal = null;
            for (i2 = 31; i2 >= 0; --i2) {
                alpha = raster.getPixel((int)(xBase + i2), (int)(yBase + y)).a;
                if (alpha > 0.0f) {
                    delta = alpha - last;
                    if ((double)Math.abs(delta) < 0.001 && lastNormal != null) {
                        normal = lastNormal;
                        lastNormal = null;
                    } else {
                        lastNormal = normal = new Vector3f(delta * intensity, 0.0f, 1.0f - Math.abs(delta)).normalizeLocal();
                    }
                    if (normals[i2][j] == null) {
                        normals[i2][j] = normal.clone();
                    } else {
                        normals[i2][j].addLocal(normal);
                    }
                    int[] nArray = counts[i2];
                    int n = j;
                    nArray[n] = nArray[n] + 1;
                }
                last = alpha;
            }
        }
        for (i = 0; i < 32; ++i) {
            Vector3f normal;
            float delta;
            int j;
            float last = (dirMask & 2) != 0 ? 0.0f : raster.getPixel((int)(xBase + i), (int)(yBase + 0)).a;
            Vector3f lastNormal = null;
            for (j = 0; j < 32; ++j) {
                float alpha = raster.getPixel((int)(xBase + i), (int)(yBase + j)).a;
                if (alpha > 0.0f) {
                    delta = alpha - last;
                    if ((double)Math.abs(delta) < 0.001 && lastNormal != null) {
                        normal = lastNormal;
                        lastNormal = null;
                    } else {
                        lastNormal = normal = new Vector3f(0.0f, -delta * intensity, 1.0f - Math.abs(delta)).normalizeLocal();
                    }
                    if (normals[i][j] == null) {
                        normals[i][j] = normal.clone();
                    } else {
                        normals[i][j].addLocal(normal);
                    }
                    int[] nArray = counts[i];
                    int n = j;
                    nArray[n] = nArray[n] + 1;
                }
                last = alpha;
            }
            last = (dirMask & 1) != 0 ? 0.0f : raster.getPixel((int)(xBase + i), (int)(yBase + 31)).a;
            lastNormal = null;
            for (j = 31; j >= 0; --j) {
                float alpha = raster.getPixel((int)(xBase + i), (int)(yBase + j)).a;
                if (alpha > 0.0f) {
                    delta = alpha - last;
                    if ((double)Math.abs(delta) < 0.001 && lastNormal != null) {
                        normal = lastNormal;
                        lastNormal = null;
                    } else {
                        lastNormal = normal = new Vector3f(0.0f, delta * intensity, 1.0f - Math.abs(delta)).normalizeLocal();
                    }
                    if (normals[i][j] == null) {
                        normals[i][j] = normal.clone();
                    } else {
                        normals[i][j].addLocal(normal);
                    }
                    int[] nArray = counts[i];
                    int n = j;
                    nArray[n] = nArray[n] + 1;
                }
                last = alpha;
            }
        }
        for (i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                Vector3f normal = normals[i][j];
                if (normal == null) {
                    normal = new Vector3f(0.0f, 0.0f, 1.0f);
                } else {
                    normal.divideLocal((float)counts[i][j]);
                }
                ColorRGBA existing = raster.getPixel(xBase + i, yBase + j);
                existing.r = normal.x * 0.5f + 0.5f;
                existing.g = normal.y * 0.5f + 0.5f;
                existing.b = normal.z * 0.5f + 0.5f;
                Vector3f v1 = new Vector3f(existing.r, existing.g, existing.b);
                v1.multLocal(2.0f, -2.0f, 2.0f);
                v1.subtractLocal(1.0f, -1.0f, 1.0f);
                raster.setPixel(xBase + i, yBase + j, existing);
            }
        }
    }

    public class SwatchData {
        private SwatchShape baseShape;
        private ImageSource source;
        private Vec3i cell;
        private int dirMask;

        public SwatchData(SwatchShape baseShape, int dirMask) {
            this.baseShape = baseShape;
            this.dirMask = dirMask;
        }

        public SwatchShape getShape() {
            return this.baseShape;
        }

        public Vec3i getCell() {
            return this.cell;
        }

        public int getDirMask() {
            return this.dirMask;
        }

        public ImageSource getImageSource() {
            return this.source;
        }
    }
}

