/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.Direction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwatchShape {
    static Logger log = LoggerFactory.getLogger(SwatchShape.class);
    private String name;
    private Vec3i sourceCell;
    private List<Direction> edges;
    private int forcedMask;
    private Map<Integer, Integer> variants = new HashMap<Integer, Integer>();

    private SwatchShape() {
    }

    public SwatchShape(String name, int xSourceCell, int ySourceCell) {
        this.name = name;
        this.sourceCell = new Vec3i(xSourceCell, ySourceCell, 0);
        this.edges = new ArrayList<Direction>();
    }

    public String getName() {
        return this.name;
    }

    public Vec3i getSourceCell() {
        return this.sourceCell;
    }

    public void addEdges(Direction ... dirs) {
        this.edges.addAll(Arrays.asList(dirs));
        Collections.sort(this.edges);
    }

    public List<Direction> getEdges() {
        return this.edges;
    }

    public static int dirsToMask(Direction ... dirs) {
        int result = 0;
        for (Direction d : dirs) {
            result |= d.getBitMask();
        }
        return result;
    }

    public static int dirsToMask(Collection<Direction> dirs) {
        int result = 0;
        for (Direction d : dirs) {
            result |= d.getBitMask();
        }
        return result;
    }

    public void setForcedMask(int dirMask) {
        this.forcedMask = dirMask;
    }

    public int getForcedMask() {
        return this.forcedMask;
    }

    public void setVariantIndex(int dirMask, int index) {
        this.variants.put(dirMask, index);
    }

    public Integer getVariantIndex(Direction ... dirs) {
        return this.getVariantIndex(SwatchShape.dirsToMask(dirs));
    }

    public Integer getVariantIndex(int dirMask) {
        return this.variants.get(dirMask);
    }

    public Map<Integer, Integer> getVariants() {
        return this.variants;
    }
}

