/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.RollupPanel;
import com.simsilica.lemur.TabbedPanel;
import com.simsilica.lemur.core.AbstractGuiControlListener;
import com.simsilica.lemur.core.GuiControl;
import com.simsilica.lemur.core.GuiControlListener;
import com.simsilica.tool.MainMenuState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(ToolState.class);
    private Container window;
    private TabbedPanel tabs;
    private ReshapeListener reshapeListener = new ReshapeListener();

    public TabbedPanel getTabs() {
        return this.tabs;
    }

    protected Node getGuiNode() {
        return ((SimpleApplication)this.getApplication()).getGuiNode();
    }

    public void toggleEnabled() {
        this.setEnabled(!this.isEnabled());
    }

    protected void initialize(Application app) {
        GuiGlobals.getInstance().getInputMapper().addDelegate(MainMenuState.F_SETTINGS, (Object)this, "toggleEnabled");
        this.window = new Container();
        ((GuiControl)this.window.getControl(GuiControl.class)).addListener((GuiControlListener)this.reshapeListener);
        RollupPanel rollup = (RollupPanel)this.window.addChild((Node)new RollupPanel("Tools", null), new Object[0]);
        this.tabs = new TabbedPanel();
        rollup.setContents((Panel)this.tabs);
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        this.getGuiNode().attachChild((Spatial)this.window);
        Vector3f pref = this.window.getPreferredSize();
        this.window.setLocalTranslation((float)this.getApplication().getCamera().getWidth() - pref.x - 10.0f, (float)(this.getApplication().getCamera().getHeight() - 20), 0.0f);
        GuiGlobals.getInstance().requestCursorEnabled((Object)this);
    }

    protected void onDisable() {
        this.window.removeFromParent();
        GuiGlobals.getInstance().releaseCursorEnabled((Object)this);
    }

    private class ReshapeListener
    extends AbstractGuiControlListener {
        private int minWidth = 350;

        private ReshapeListener() {
        }

        public void reshape(GuiControl source, Vector3f pos, Vector3f size) {
            Vector3f windowSize = ToolState.this.window.getSize();
            if (windowSize.x < (float)this.minWidth) {
                windowSize.x = this.minWidth;
                ToolState.this.window.setSize(windowSize);
            }
            Vector3f loc = new Vector3f((float)ToolState.this.getApplication().getCamera().getWidth() - windowSize.x - 10.0f, (float)(ToolState.this.getApplication().getCamera().getHeight() - 20), 0.0f);
            ToolState.this.window.setLocalTranslation(loc);
        }
    }
}

