/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool.io;

import com.google.common.base.Charsets;
import com.simsilica.mblock.CellArray;
import com.simsilica.tool.ClothingBuilder;
import com.simsilica.tool.FabricInfo;
import com.simsilica.tool.SwatchIndex;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClothingFormat {
    static Logger log = LoggerFactory.getLogger(ClothingFormat.class);
    private static Pattern TRIPLE = Pattern.compile("%\\w+:\\s*(\\d+)\\s*,\\s*(\\d+)\\s*,\\s*(\\d+)");
    private static Pattern VALUE = Pattern.compile("%\\w+:\\s*(\\w+)\\s*=\\s*(.+)");
    private static Pattern NUM_PAIR = Pattern.compile("(\\d+):(\\d+)");
    private List<FabricInfo> fabrics;
    private SwatchIndex swatchIndex;

    public ClothingFormat(List<FabricInfo> fabrics, SwatchIndex swatchIndex) {
        this.fabrics = fabrics;
        this.swatchIndex = swatchIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CellArray readCells(InputStream rawIn) throws IOException {
        InputStreamReader rIn = new InputStreamReader(rawIn, Charsets.UTF_8);
        try (BufferedReader in = new BufferedReader(rIn);){
            String line = null;
            CellArray cells = null;
            CellArray target = null;
            int sizeX = 0;
            int sizeY = 0;
            int sizeZ = 0;
            int minX = 0;
            int minY = 0;
            int minZ = 0;
            int maxX = 0;
            int maxY = 0;
            int maxZ = 0;
            int y = 0;
            int z = 0;
            while ((line = in.readLine()) != null) {
                int[] sizes;
                if ((line = line.trim()).startsWith("#") || line.startsWith("//")) continue;
                if (line.startsWith("%Clothing version")) {
                    if (line.equals("%Clothing version 1")) continue;
                    throw new IOException("Unsupported version:" + line);
                }
                if (line.startsWith("%order")) {
                    if (line.equals("%order: z, y, x")) continue;
                    throw new IOException("Unsupported order:" + line);
                }
                if (line.startsWith("%compression")) {
                    if (line.equals("%compression: none")) continue;
                    throw new IOException("Unsupported compression:" + line);
                }
                if (line.startsWith("%fabric:") || line.startsWith("%swatch:")) continue;
                if (line.startsWith("%size")) {
                    sizes = ClothingFormat.parseTriple(line);
                    if (sizes == null) {
                        throw new IOException("Bad format in size directive:" + line);
                    }
                    sizeX = sizes[0];
                    sizeY = sizes[1];
                    sizeZ = sizes[2];
                    target = cells = new CellArray(sizeX, sizeY, sizeZ);
                    continue;
                }
                if (line.startsWith("%min:")) {
                    sizes = ClothingFormat.parseTriple(line);
                    if (sizes == null) {
                        throw new IOException("Bad format in min directive:" + line);
                    }
                    minX = sizes[0];
                    minY = sizes[1];
                    minZ = sizes[2];
                    y = minY;
                    z = minZ;
                    continue;
                }
                if (line.startsWith("%max:")) {
                    sizes = ClothingFormat.parseTriple(line);
                    if (sizes == null) {
                        throw new IOException("Bad format in max directive:" + line);
                    }
                    maxX = sizes[0];
                    maxY = sizes[1];
                    maxZ = sizes[2];
                    continue;
                }
                if (line.startsWith("%z:")) {
                    z = Integer.parseInt(line.substring("%z:".length()));
                    y = minY;
                    continue;
                }
                if (line.startsWith("%")) {
                    throw new IOException("Unhandled directive:" + line);
                }
                String[] tokens = line.split(",\\s*");
                for (int i = 0; i < tokens.length; ++i) {
                    int[] values = ClothingFormat.parsePair(tokens[i]);
                    int value = ClothingBuilder.toCell(values[1], values[0]);
                    target.setCell(minX + i, y, z, value);
                }
                ++y;
            }
            CellArray cellArray = cells;
            return cellArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCells(OutputStream rawOut, CellArray cells) throws IOException {
        HashMap<Integer, String> fabricNames = new HashMap<Integer, String>();
        HashMap<Integer, SwatchIndex.SwatchData> swatches = new HashMap<Integer, SwatchIndex.SwatchData>();
        OutputStreamWriter sOut = new OutputStreamWriter(rawOut, Charsets.UTF_8);
        try (PrintWriter out = new PrintWriter(sOut);){
            int val;
            int sizeX = cells.getSizeX();
            int sizeY = cells.getSizeY();
            int sizeZ = cells.getSizeZ();
            int minX = sizeX;
            int minY = sizeY;
            int minZ = sizeZ;
            int maxX = 0;
            int maxY = 0;
            int maxZ = 0;
            for (int x = 0; x < sizeX; ++x) {
                for (int y = 0; y < sizeY; ++y) {
                    for (int z = 0; z < sizeZ; ++z) {
                        val = cells.getCell(x, y, z);
                        if (val == 0) continue;
                        minX = Math.min(minX, x);
                        maxX = Math.max(maxX, x);
                        minY = Math.min(minY, y);
                        maxY = Math.max(maxY, y);
                        minZ = Math.min(minZ, z);
                        maxZ = Math.max(maxZ, z);
                        int shapeIndex = ClothingBuilder.toShape(val);
                        int fabricIndex = ClothingBuilder.toFabric(val);
                        FabricInfo info = this.fabrics.get(fabricIndex);
                        fabricNames.put(fabricIndex, info.getName());
                        swatches.put(shapeIndex, this.swatchIndex.getSwatchData(shapeIndex));
                    }
                }
            }
            if (minX == sizeX) {
                minX = 0;
            }
            if (minY == sizeY) {
                minY = 0;
            }
            if (minZ == sizeZ) {
                minZ = 0;
            }
            out.println("%Clothing version 1");
            out.println("%size: " + sizeX + ", " + sizeY + ", " + sizeZ);
            out.println("%order: z, y, x");
            out.println("%compression: none");
            for (Map.Entry e : fabricNames.entrySet()) {
                out.println("%fabric:" + e.getKey() + "=" + (String)e.getValue());
            }
            for (Map.Entry e : swatches.entrySet()) {
                out.println("%swatch:" + e.getKey() + "=" + ((SwatchIndex.SwatchData)e.getValue()).getCell() + ", " + ((SwatchIndex.SwatchData)e.getValue()).getDirMask() + ", " + ((SwatchIndex.SwatchData)e.getValue()).getShape().getName());
            }
            out.println("%min: " + minX + ", " + minY + ", " + minZ);
            out.println("%max: " + maxX + ", " + maxY + ", " + maxZ);
            for (int z = minZ; z <= maxZ; ++z) {
                out.println("%z:" + z);
                for (int y = minY; y <= maxY; ++y) {
                    for (int x = minX; x <= maxX; ++x) {
                        val = cells.getCell(x, y, z);
                        int shape = ClothingBuilder.toShape(val);
                        int fabric = ClothingBuilder.toFabric(val);
                        out.print(fabric + ":" + shape);
                        if (x >= maxX) continue;
                        out.print(", ");
                    }
                    out.println();
                }
            }
        }
    }

    private static int[] parseTriple(String s) {
        Matcher m = TRIPLE.matcher(s);
        if (!m.matches()) {
            return null;
        }
        int[] result = new int[3];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Integer.parseInt(m.group(i + 1));
        }
        return result;
    }

    private static String[] parseValue(String s) {
        Matcher m = VALUE.matcher(s);
        if (!m.matches()) {
            return null;
        }
        String[] result = new String[2];
        for (int i = 0; i < result.length; ++i) {
            result[i] = m.group(i + 1);
        }
        return result;
    }

    private static int[] parsePair(String s) {
        Matcher m = NUM_PAIR.matcher(s);
        if (!m.matches()) {
            return null;
        }
        int[] result = new int[]{Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2))};
        return result;
    }
}

