/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool.io;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.simsilica.tool.RigInfo;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RigInfoJson {
    static Logger log = LoggerFactory.getLogger(RigInfoJson.class);
    private static RigInfoJson instance = new RigInfoJson();
    private Gson gson;

    public RigInfoJson() {
        this.initializeGson();
    }

    protected void initializeGson() {
        GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting();
        this.gson = gsonBuilder.create();
    }

    public String toJson(RigInfo rigInfo) {
        return this.gson.toJson((Object)rigInfo);
    }

    public RigInfo fromJson(String json) {
        return (RigInfo)this.gson.fromJson(json, RigInfo.class);
    }

    public static RigInfo load(File f) {
        try {
            String json = Files.toString((File)f, (Charset)Charsets.UTF_8);
            RigInfo result = instance.fromJson(json);
            result.upgrade();
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading:" + f, e);
        }
    }

    public static void store(RigInfo rigInfo, File f) {
        try {
            String json = instance.toJson(rigInfo);
            Files.write((CharSequence)json, (File)f, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Error storing:" + f, e);
        }
    }
}

