/*
 * Decompiled with CFR 0.152.
 */
package mythruna.server;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerConfig {
    public static final String DEFAULT_WORLD_LIBRARY = "worlds";
    static Logger log = LoggerFactory.getLogger(ServerConfig.class);
    private transient File configFile;
    private File configDir;
    private String worldLibrary;
    private String worldDir;
    private String serverDescription = "This is my server.";
    private int port = 4234;
    private static ServerConfig instance;

    private ServerConfig() {
    }

    protected void initializeDefaults(String serverName) {
        String userHome = System.getProperty("user.home");
        this.configDir = new File(new File(userHome) + "/.mythruna2/");
        if (!this.configDir.exists()) {
            this.configDir.mkdirs();
        }
        this.worldLibrary = DEFAULT_WORLD_LIBRARY;
        this.worldDir = serverName;
    }

    protected void upgrade() {
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public File getWorldLibrary() {
        return new File(this.configDir, this.worldLibrary);
    }

    public String getWorldDir() {
        return this.worldDir;
    }

    public String getServerDescription() {
        return this.serverDescription;
    }

    public int getPort() {
        return this.port;
    }

    public static ServerConfig getInstance(String serverName, boolean init) {
        if (instance != null) {
            return instance;
        }
        File f = new File(serverName + ".server-config");
        if (f.exists()) {
            try {
                instance = ServerConfig.load(f);
                ServerConfig.instance.configFile = f;
            }
            catch (Exception e) {
                log.error("Error loading config file.  Initializing defaults.", (Throwable)e);
            }
        } else if (init) {
            instance = new ServerConfig();
            instance.initializeDefaults(serverName);
            if (!f.exists()) {
                try {
                    ServerConfig.store(instance, f);
                }
                catch (Exception e) {
                    log.error("Error storing sample config file", (Throwable)e);
                }
            }
        } else {
            log.error("Server config does not exist:" + f);
            log.info("Try the -init option.");
        }
        if (ServerConfig.instance.configDir == null) {
            ServerConfig.instance.configDir = new File(".");
        }
        log.info("Using config dir:" + ServerConfig.instance.configDir);
        return instance;
    }

    public static ServerConfig load(File f) {
        GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting();
        Gson gson = gsonBuilder.create();
        try {
            String json = Files.toString((File)f, (Charset)Charsets.UTF_8);
            ServerConfig config = (ServerConfig)gson.fromJson(json, ServerConfig.class);
            config.upgrade();
            return config;
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading:" + f, e);
        }
    }

    public static void store(ServerConfig config, File f) {
        GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting();
        Gson gson = gsonBuilder.create();
        try {
            log.info("Storing:" + f);
            String json = gson.toJson((Object)config);
            Files.write((CharSequence)json, (File)f, (Charset)Charsets.UTF_8);
            config.configFile = f;
        }
        catch (IOException e) {
            throw new RuntimeException("Error storing:" + f, e);
        }
    }
}

