/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.app.state;

import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.renderer.RenderManager;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BaseAppState
implements AppState {
    private static final Logger log = Logger.getLogger(BaseAppState.class.getName());
    private Application app;
    private boolean initialized;
    private boolean enabled = true;
    private String id;

    protected BaseAppState() {
    }

    protected BaseAppState(String id) {
        this.id = id;
    }

    protected abstract void initialize(Application var1);

    protected abstract void cleanup(Application var1);

    protected abstract void onEnable();

    protected abstract void onDisable();

    @Override
    public final void initialize(AppStateManager stateManager, Application app) {
        log.log(Level.FINEST, "initialize():{0}", this);
        this.app = app;
        this.initialized = true;
        this.initialize(app);
        if (this.isEnabled()) {
            log.log(Level.FINEST, "onEnable():{0}", this);
            this.onEnable();
        }
    }

    @Override
    public final boolean isInitialized() {
        return this.initialized;
    }

    protected void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public final Application getApplication() {
        return this.app;
    }

    public final AppStateManager getStateManager() {
        return this.app.getStateManager();
    }

    public final <T extends AppState> T getState(Class<T> type) {
        return this.getState(type, false);
    }

    public final <T extends AppState> T getState(Class<T> type, boolean failOnMiss) {
        return this.getStateManager().getState(type, failOnMiss);
    }

    public final <T extends AppState> T getState(String id, Class<T> type) {
        return this.getState(id, type, false);
    }

    public final <T extends AppState> T getState(String id, Class<T> type, boolean failOnMiss) {
        if (failOnMiss) {
            return this.getStateManager().stateForId(id, type);
        }
        return this.getStateManager().getState(id, type);
    }

    @Override
    public final void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        if (!this.isInitialized()) {
            return;
        }
        if (enabled) {
            log.log(Level.FINEST, "onEnable():{0}", this);
            this.onEnable();
        } else {
            log.log(Level.FINEST, "onDisable():{0}", this);
            this.onDisable();
        }
    }

    @Override
    public final boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void stateAttached(AppStateManager stateManager) {
    }

    @Override
    public void stateDetached(AppStateManager stateManager) {
    }

    @Override
    public void update(float tpf) {
    }

    @Override
    public void render(RenderManager rm) {
    }

    @Override
    public void postRender() {
    }

    @Override
    public final void cleanup() {
        log.log(Level.FINEST, "cleanup():{0}", this);
        if (this.isEnabled()) {
            log.log(Level.FINEST, "onDisable():{0}", this);
            this.onDisable();
        }
        this.cleanup(this.app);
        this.initialized = false;
    }
}

