/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.fractal;

import com.google.common.base.MoreObjects;
import com.simsilica.fractal.AbstractSampler;
import com.simsilica.fractal.CellularNoise;
import com.simsilica.fractal.SamplerRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCellularSampler
extends AbstractSampler {
    static Logger log = LoggerFactory.getLogger(CellularNoise.class);
    private long seed = 0L;

    protected AbstractCellularSampler(long seed, double min, double max) {
        super(min, max);
        this.seed = seed;
    }

    protected AbstractCellularSampler(long seed, SamplerRange range) {
        super(range);
        this.seed = seed;
    }

    public long getSeed() {
        return this.seed;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("seed", this.seed).toString();
    }

    protected final double getRandomX(double x, double z) {
        double dot1 = (x * 127.1 + z * 311.7 + (double)this.seed * 783.089) % Math.PI;
        return Math.abs(Math.sin(dot1) * 43758.5453 % 1.0);
    }

    protected final double getRandomZ(double x, double z) {
        double dot2 = (x * 269.5 + z * 183.3) % Math.PI;
        return Math.abs(Math.sin(dot2) * 43758.5453 % 1.0);
    }
}

