/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.db;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.Direction;
import com.simsilica.mblock.MaskUtils;
import com.simsilica.mworld.DataVersion;
import com.simsilica.mworld.LeafData;
import com.simsilica.mworld.LeafId;
import com.simsilica.mworld.LeafInfo;
import com.simsilica.mworld.db.LeafDb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestLeafDb
implements LeafDb {
    static Logger log = LoggerFactory.getLogger(TestLeafDb.class);
    public static final int LEAF_SIZE = 32;
    private double yMin = 0.0;
    private double yMax;
    private double seaLevel = 64.0;
    private double yRange;
    private double xScale = 256.0;
    private double zScale = 256.0;
    private CellData worldData = new GeneratedCellData();
    private int snowElevation = 110;
    private int underWaterType = 16;
    private int landType = 32;
    private int snowType = 43;

    public TestLeafDb() {
        this(64);
    }

    public TestLeafDb(int maxHeightAboveSeaLevel) {
        this.yMax = this.seaLevel + (double)maxHeightAboveSeaLevel;
        this.yRange = this.yMax - this.yMin;
    }

    public TestLeafDb(int seaLevel, int snowElevation, int maxHeight, int underWaterType, int landType, int snowType) {
        this.seaLevel = seaLevel;
        this.snowElevation = snowElevation;
        this.yMax = maxHeight;
        this.yRange = this.yMax - this.yMin;
        this.underWaterType = underWaterType;
        this.landType = landType;
        this.snowType = snowType;
    }

    @Override
    public LeafData loadLeaf(LeafId leafId) {
        Vec3i world = leafId.getWorld(null);
        CellArray cells = new CellArray(32);
        int empty = 32768;
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                for (int k = 0; k < 32; ++k) {
                    int x = world.x + i;
                    int y = world.y + j;
                    int z = world.z + k;
                    int val = this.worldData.getCell(x, y, z);
                    if (val == 0) continue;
                    int sideMask = MaskUtils.calculateSideMask((int)x, (int)y, (int)z, (CellData)this.worldData);
                    int cell = MaskUtils.setSideMask((int)val, (int)sideMask);
                    cells.setCell(i, j, k, cell);
                    --empty;
                }
            }
        }
        return new LeafData(new LeafInfo(world, leafId, new DataVersion(0L)), cells, empty);
    }

    @Override
    public void storeLeaf(LeafData leaf) {
    }

    private class GeneratedCellData
    implements CellData {
        private GeneratedCellData() {
        }

        public int getCell(int x, int y, int z) {
            int val;
            double xSin = Math.sin(Math.PI * (double)x / TestLeafDb.this.xScale);
            double zSin = Math.sin(Math.PI * (double)z / TestLeafDb.this.zScale);
            double sin = xSin * zSin;
            double elevation = (sin = sin * sin * sin) < 0.0 ? (double)Math.round(TestLeafDb.this.yMin + sin * TestLeafDb.this.seaLevel + TestLeafDb.this.seaLevel) : (double)Math.round(TestLeafDb.this.yMin + sin * (TestLeafDb.this.yRange - TestLeafDb.this.seaLevel) + TestLeafDb.this.seaLevel);
            if ((double)y >= elevation) {
                return 0;
            }
            int n = val = elevation < TestLeafDb.this.seaLevel ? TestLeafDb.this.underWaterType : TestLeafDb.this.landType;
            if (elevation > (double)TestLeafDb.this.snowElevation) {
                val = TestLeafDb.this.snowType;
            }
            return val;
        }

        public int getCell(int x, int y, int z, int defaultValue) {
            return this.getCell(x, y, z);
        }

        public int getCell(int x, int y, int z, Direction dir, int defaultValue) {
            Vec3i v = dir.getVec3i();
            return this.getCell(x + v.x, y + v.y, z + v.z, defaultValue);
        }

        public void setCell(int x, int y, int z, int type) {
            throw new UnsupportedOperationException("Cannot set values back to function-generated data.");
        }
    }
}

