/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.tile.insert;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.DataVersion;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.tile.insert.BlockInsert;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsertLayer {
    static Logger log = LoggerFactory.getLogger(InsertLayer.class);
    private static int COLUMN_SIZE = 32;
    private TileId tileId;
    private DataVersion version;
    private List<BlockInsert> insertList;
    private ListMultimap<Short, BlockInsert> binIndex;

    public InsertLayer(TileId tileId, DataVersion version) {
        this(tileId, version, new ArrayList<BlockInsert>());
    }

    public InsertLayer(TileId tileId, DataVersion version, List<BlockInsert> insertList) {
        this.tileId = tileId;
        this.version = version;
        this.insertList = insertList;
        this.binIndex = MultimapBuilder.hashKeys().arrayListValues().build();
        for (BlockInsert insert : insertList) {
            this.indexInsert(insert);
        }
    }

    public TileId getTileId() {
        return this.tileId;
    }

    public DataVersion getVersion() {
        return this.version;
    }

    public List<BlockInsert> getInserts() {
        return this.insertList;
    }

    public Set<Short> getActiveBinIds() {
        return this.binIndex.keySet();
    }

    protected boolean indexInsert(BlockInsert insert) {
        boolean hit = false;
        for (Short s : insert.getAffectedColumns(this.tileId)) {
            this.binIndex.put((Object)s, (Object)insert);
            hit = true;
        }
        return hit;
    }

    public boolean addInsert(BlockInsert insert) {
        if (this.indexInsert(insert)) {
            this.insertList.add(insert);
            return true;
        }
        log.warn("Insert:" + insert + " did not hit any columns in:" + this.tileId + "(" + this.tileId.getWorld(null) + ")");
        return false;
    }

    public Iterable<BlockInsert> getInserts(ColumnId columnId) {
        short binId = columnId.getTileLocalIndexId();
        return this.binIndex.get((Object)binId);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[tileId:" + this.tileId + ", version:" + this.version + ", size:" + this.insertList.size() + "]";
    }
}

