/*
 * Decompiled with CFR 0.152.
 */
package mythruna.net.server;

import com.google.common.base.Supplier;
import com.jme3.network.HostedConnection;
import com.jme3.network.service.AbstractHostedConnectionService;
import com.jme3.network.service.HostedServiceManager;
import com.jme3.network.service.rmi.RmiHostedService;
import com.jme3.network.service.rmi.RmiRegistry;
import com.simsilica.account.Account;
import com.simsilica.account.AccountManager;
import com.simsilica.es.CreatedBy;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.es.Name;
import com.simsilica.event.EventBus;
import com.simsilica.event.EventType;
import com.simsilica.event.PlayerEntityEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import mythruna.net.AccountEvent;
import mythruna.net.AccountListener;
import mythruna.net.AccountSession;
import mythruna.net.server.GameSessionHostedService;
import mythruna.world.WorldManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountHostedService
extends AbstractHostedConnectionService {
    static Logger log = LoggerFactory.getLogger(AccountHostedService.class);
    private static final String ATTRIBUTE_ACCOUNT = Account.class.getName();
    private static final String ATTRIBUTE_SESSION = AccountHostedService.class.getName();
    private RmiHostedService rmiService;
    private int channel;
    private WorldManager worldManager;
    private EntityData ed;
    private AccountManager accounts;
    private Supplier<String> tokenSupplier;

    public AccountHostedService(WorldManager worldManager, EntityData ed, Supplier<String> tokenSupplier) {
        this(worldManager, ed, tokenSupplier, -2);
    }

    public AccountHostedService(WorldManager worldManager, EntityData ed, Supplier<String> tokenSupplier, int channel) {
        this.worldManager = worldManager;
        this.ed = ed;
        this.channel = channel;
        this.tokenSupplier = tokenSupplier;
    }

    public AccountHostedService(WorldManager worldManager, EntityData ed, AccountManager accounts) {
        this(worldManager, ed, accounts, -2);
    }

    public AccountHostedService(WorldManager worldManager, EntityData ed, AccountManager accounts, int channel) {
        this.worldManager = worldManager;
        this.ed = ed;
        this.channel = channel;
        this.accounts = accounts;
    }

    public static Account getAccount(HostedConnection conn) {
        return (Account)conn.getAttribute(ATTRIBUTE_ACCOUNT);
    }

    protected AccountSessionImpl getSession(HostedConnection conn) {
        return (AccountSessionImpl)conn.getAttribute(ATTRIBUTE_SESSION);
    }

    protected void onInitialize(HostedServiceManager s) {
        this.rmiService = (RmiHostedService)this.getService(RmiHostedService.class);
        if (this.rmiService == null) {
            throw new RuntimeException(((Object)((Object)this)).getClass().getSimpleName() + " requires an RMI service.");
        }
    }

    public void startHostingOnConnection(HostedConnection conn) {
        log.debug("startHostingOnConnection(" + conn + ")");
        AccountSessionImpl session = new AccountSessionImpl(conn);
        conn.setAttribute(ATTRIBUTE_SESSION, (Object)session);
        RmiRegistry rmi = this.rmiService.getRmiRegistry(conn);
        rmi.share((byte)this.channel, (Object)session, AccountSession.class);
    }

    public void stopHostingOnConnection(HostedConnection conn) {
        log.debug("stopHostingOnConnection(" + conn + ")");
        AccountSessionImpl session = this.getSession(conn);
        if (session != null) {
            session.close();
            conn.setAttribute(ATTRIBUTE_SESSION, null);
        }
    }

    private class AccountSessionImpl
    implements AccountSession,
    AccountListener {
        private HostedConnection conn;
        private AccountListener callback;
        private EntityId userEntity;
        private boolean loggedIn;
        private String randomSalt;
        private Account account;

        public AccountSessionImpl(HostedConnection conn) {
            this.conn = conn;
        }

        public void close() {
            EventBus.publish(AccountEvent.accountLoggedOff, (Object)new AccountEvent(this.account, this.conn));
        }

        protected AccountListener getCallback() {
            if (this.callback == null) {
                RmiRegistry rmi = AccountHostedService.this.rmiService.getRmiRegistry(this.conn);
                this.callback = (AccountListener)rmi.getRemoteObject(AccountListener.class);
                if (this.callback == null) {
                    throw new RuntimeException("Unable to locate client callback for AccountListener");
                }
            }
            return this.callback;
        }

        protected void checkLoggedIn() {
            if (!this.loggedIn) {
                throw new RuntimeException("Permission denied");
            }
        }

        @Override
        public void knock() {
            if (AccountHostedService.this.tokenSupplier != null) {
                this.challenge("nosalt", new ArrayList<String>(Arrays.asList("token")));
            } else {
                this.randomSalt = UUID.randomUUID().toString();
                this.challenge(this.randomSalt, AccountHostedService.this.accounts.getCredentialTypes());
            }
        }

        @Override
        public void login(String userId, Map<String, Object> credentials) {
            log.info("login(" + userId + ", " + credentials + ")");
            if (credentials == null || credentials.isEmpty()) {
                this.loginStatus(false, "No user credentials supplied");
                return;
            }
            if (AccountHostedService.this.accounts != null) {
                try {
                    this.account = AccountHostedService.this.accounts.login(userId, this.randomSalt, credentials);
                }
                catch (Exception e) {
                    log.error("Login failed for:" + userId + " credentialss:" + credentials, (Throwable)e);
                    this.loginStatus(false, "Authentication failed.");
                    return;
                }
            } else if (AccountHostedService.this.tokenSupplier != null) {
                String token = (String)credentials.get("token");
                if (token == null) {
                    this.loginStatus(false, "Token login required and no token supplied.");
                    return;
                }
                if (!Objects.equals(token, AccountHostedService.this.tokenSupplier.get())) {
                    this.loginStatus(false, "Invalid user or credentials");
                    return;
                }
            } else {
                this.loginStatus(false, "No authentication mechanism configured");
                return;
            }
            this.userEntity = AccountHostedService.this.ed.findEntity(Filters.fieldEquals(Name.class, (String)"name", (Object)userId), new Class[]{Name.class});
            if (this.userEntity == null) {
                this.loginStatus(false, "Failed to find user entity.");
                this.account = null;
                return;
            }
            log.info("Logged in userId:" + userId + "  entity:" + this.userEntity);
            this.conn.setAttribute(ATTRIBUTE_ACCOUNT, (Object)this.account);
            EventBus.publish(AccountEvent.accountLoggedOn, (Object)new AccountEvent(this.account, this.conn));
            this.loginStatus(true, null);
        }

        @Override
        public void createAccount(String userId, Map<String, Object> credentials) {
            log.info("createAccount(" + userId + ", " + credentials + ")");
            HashMap<String, Object> info = new HashMap<String, Object>();
            info.putAll(credentials);
            try {
                Account acct = AccountHostedService.this.accounts.createAccount(userId, info);
                EntityId user = AccountHostedService.this.ed.findEntity(Filters.fieldEquals(Name.class, (String)"name", (Object)userId), new Class[]{Name.class});
                if (user != null) {
                    log.warn("userID:" + userId + "  seems to already have an entity:" + user);
                } else {
                    user = AccountHostedService.this.ed.createEntity();
                    AccountHostedService.this.ed.setComponents(user, new EntityComponent[]{new Name(userId)});
                }
                EventBus.publish(AccountEvent.accountCreated, (Object)new AccountEvent(acct, this.conn));
                this.accountStatus(true, null);
            }
            catch (Exception e) {
                log.error("Failed to create account for:" + userId + " info:" + info, (Throwable)e);
                this.accountStatus(false, "Account creation failed:" + e.getMessage());
            }
        }

        @Override
        public EntityId getUserEntity() {
            this.checkLoggedIn();
            return this.userEntity;
        }

        @Override
        public void createCharacter(String name, EntityComponent ... components) {
            if (!this.loggedIn) {
                return;
            }
            EntityId character = AccountHostedService.this.ed.createEntity();
            AccountHostedService.this.ed.setComponents(character, components);
            AccountHostedService.this.ed.setComponents(character, new EntityComponent[]{new Name(name), new CreatedBy(this.userEntity)});
            EventBus.publish((EventType)PlayerEntityEvent.playerEntityCreated, (Object)new PlayerEntityEvent(character, this.conn));
        }

        @Override
        public void enterWorld(EntityId character) {
            this.checkLoggedIn();
            log.info("enterWorld(" + character + ")");
            EventBus.publish((EventType)PlayerEntityEvent.playerEntityJoining, (Object)new PlayerEntityEvent(character, this.conn));
            CreatedBy creator = (CreatedBy)AccountHostedService.this.ed.getComponent(character, CreatedBy.class);
            if (creator == null) {
                throw new RuntimeException("Invalid character:" + character);
            }
            log.info("  owner:" + creator);
            if (!Objects.equals(this.userEntity, creator.getCreatorId())) {
                throw new RuntimeException("Invalid character:" + character + " for player:" + this.userEntity);
            }
            ((GameSessionHostedService)AccountHostedService.this.getService(GameSessionHostedService.class)).startHostingOnConnection(this.conn, character);
        }

        @Override
        public EntityId getWorldEntity() {
            return AccountHostedService.this.worldManager.getWorldEntity();
        }

        @Override
        public void challenge(String randomSalt, List<String> caps) {
            this.getCallback().challenge(randomSalt, caps);
        }

        @Override
        public void loginStatus(boolean loggedIn, String message) {
            this.loggedIn = loggedIn;
            this.getCallback().loginStatus(loggedIn, message);
        }

        @Override
        public void accountStatus(boolean success, String message) {
            this.getCallback().accountStatus(success, message);
        }
    }
}

