/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.town;

import com.google.common.collect.Iterables;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.BlockName;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mworld.BlockData;
import com.simsilica.mworld.BlockDataId;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.TerrainImageType;
import com.simsilica.mworld.tile.Tile;
import com.simsilica.mworld.tile.TileFunction;
import com.simsilica.mworld.tile.insert.BlockInsert;
import com.simsilica.mworld.tile.insert.InsertLayer;
import java.util.HashSet;
import java.util.Random;
import mythruna.world.town.TestBlockRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TownTestTileFunction
implements TileFunction {
    static Logger log = LoggerFactory.getLogger(TownTestTileFunction.class);
    private int seaLevel = 128;
    private int woodType;
    private int waddleType;
    private Vec3d spawnLoc;
    private TileId spawnTileId;
    private TestBlockRegistry blocksRegistry;

    public TownTestTileFunction(TestBlockRegistry blocksRegistry, Vec3d spawnLoc) {
        int badType = BlockTypeIndex.getBadTypeIndex();
        this.woodType = BlockTypeIndex.findType((BlockName)new BlockName("wood", "cube"), (int)badType);
        this.waddleType = BlockTypeIndex.findType((BlockName)new BlockName("W&D", "cube"), (int)badType);
        this.blocksRegistry = blocksRegistry;
        this.spawnLoc = spawnLoc;
        this.spawnTileId = TileId.fromWorld((double)spawnLoc.x, (double)spawnLoc.z);
    }

    public void accept(Tile tile) {
        InsertLayer inserts = (InsertLayer)tile.get(InsertLayer.class);
        if (inserts.getVersion().getLoadVersion() >= 0L) {
            return;
        }
        Vec3i origin = tile.getTileId().getWorld(null);
        TerrainImage terrain = (TerrainImage)tile.get((Object)TerrainImageType.Terrain, TerrainImage.class);
        TerrainImage fluid = (TerrainImage)tile.get((Object)TerrainImageType.Fluid, TerrainImage.class);
        if (tile.getTileId().getId() == this.spawnTileId.getId()) {
            Vec3i pos = new Vec3i((int)this.spawnLoc.x - origin.x, (int)this.spawnLoc.y, (int)this.spawnLoc.z - origin.z);
            TestBlockRegistry.BuildingFactory factory = this.blocksRegistry.getSpawnTower();
            BlockDataId blockDataId = this.blocksRegistry.findFirst(factory.name);
            int carveFlags = 2;
            BlockData data = this.blocksRegistry.apply(blockDataId);
            int xSize = data.getCells().getSizeX();
            int ySize = data.getCells().getSizeY();
            int zSize = data.getCells().getSizeZ();
            Vec3i loc = pos.add(origin).subtractLocal(4, 1, 4);
            int xBase = pos.x - 4;
            int zBase = pos.z - 4;
            int total = 0;
            int samples = 0;
            for (int x = 0; x < xSize; ++x) {
                for (int z = 0; z < zSize; ++z) {
                    if (xBase + x < 0 || xBase + x > 1023 || zBase + z < 0 || zBase + z > 1023) continue;
                    total += terrain.getElevation(xBase + x, zBase + z);
                    ++samples;
                }
            }
            loc.y = (int)Math.round((double)total / (double)samples);
            loc.y -= factory.yOffset;
            inserts.addInsert(new BlockInsert(loc, blockDataId, carveFlags, xSize, ySize, zSize, factory.aboveGround, factory.groundLevel, -1L));
        }
        int[][] roughness = new int[1024][1024];
        int kernelRadius = 5;
        int kernelSize = kernelRadius * 2 + 1;
        for (int x = 0; x < 1024; ++x) {
            for (int z = 0; z < 1024; ++z) {
                int min = Integer.MAX_VALUE;
                int max = Integer.MIN_VALUE;
                for (int i = 0; i < kernelSize; ++i) {
                    for (int j = 0; j < kernelSize; ++j) {
                        int z1;
                        int x1 = x - kernelRadius + i;
                        if (x1 < 0 || x1 >= 1024 || (z1 = z - kernelRadius + j) < 0 || z1 >= 1024) continue;
                        short e = terrain.getElevation(x1, z1);
                        min = Math.min(e, min);
                        max = Math.max(e, max);
                    }
                }
                roughness[x][z] = max - min;
            }
        }
        int count = 0;
        int threshold = 2;
        HashSet<Vec3i> candidates = new HashSet<Vec3i>();
        for (int x = 0; x < 1024; ++x) {
            for (int z = 0; z < 1024; ++z) {
                int r = roughness[x][z];
                short e = terrain.getElevation(x, z);
                byte f = fluid.getType(x, z);
                if (Math.abs(r) < threshold && e > this.seaLevel && f <= 0) {
                    ++count;
                    candidates.add(new Vec3i(x, (int)e, z));
                    roughness[x][z] = e;
                    continue;
                }
                roughness[x][z] = -1;
            }
        }
        log.info("Smooth count:" + count);
        Random rand = new Random(tile.getTileId().getId());
        int buildingCount = 1 + rand.nextInt(Math.max(1, count / 1000));
        log.info("Building count:" + buildingCount);
        int grass = 9;
        for (int i = 0; i < buildingCount; ++i) {
            if (candidates.isEmpty()) {
                log.warn("Ran out of candidates");
                break;
            }
            int index = rand.nextInt(candidates.size());
            Vec3i pos = (Vec3i)Iterables.get(candidates, (int)index);
            log.info("Building:" + pos);
            int xSize = (2 + rand.nextInt(2)) * 4 + 2;
            int ySize = 0;
            TestBlockRegistry.BuildingFactory factory = this.blocksRegistry.getRandomBuilding(rand);
            BlockDataId blockDataId = this.blocksRegistry.getRandomOrientation(factory, rand);
            int carveFlags = 2;
            BlockData data = this.blocksRegistry.apply(blockDataId);
            xSize = data.getCells().getSizeX();
            ySize = data.getCells().getSizeY();
            int zSize = data.getCells().getSizeZ();
            Vec3i loc = pos.add(origin).subtractLocal(xSize / 2, 1, zSize / 2);
            int xBase = pos.x - xSize / 2;
            int zBase = pos.z - zSize / 2;
            if (xBase < 0) {
                loc.x -= xBase;
                xBase = 0;
            } else if (xBase + xSize > 1024) {
                loc.x -= xBase + xSize - 1024;
                xBase = 1024 - xSize;
            }
            if (zBase < 0) {
                loc.z -= zBase;
                zBase = 0;
            } else if (zBase + zSize > 1024) {
                loc.z -= zBase + zSize - 1024;
                zBase = 1024 - zSize;
            }
            int total = 0;
            int samples = 0;
            for (int x = 0; x < xSize; ++x) {
                for (int z = 0; z < zSize; ++z) {
                    if (xBase + x < 0 || xBase + x > 1023 || zBase + z < 0 || zBase + z > 1023) continue;
                    total += terrain.getElevation(xBase + x, zBase + z);
                    ++samples;
                }
            }
            loc.y = (int)Math.round((double)total / (double)samples);
            loc.y -= factory.yOffset;
            inserts.addInsert(new BlockInsert(loc, blockDataId, carveFlags, xSize, ySize, zSize, factory.aboveGround, factory.groundLevel, -1L));
            candidates.remove(pos);
        }
    }
}

