/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client;

import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Command;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Insets3f;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.OptionPanelState;
import com.simsilica.lemur.component.BorderLayout;
import com.simsilica.lemur.component.IconComponent;
import com.simsilica.lemur.core.GuiComponent;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.event.PopupState;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.state.CompositeAppState;
import mythruna.client.ConfigurationState;
import mythruna.client.CreateWorldState;
import mythruna.client.GameInfo;
import mythruna.client.GameSettingsState;
import mythruna.client.GuiState;
import mythruna.client.WorldListState;
import mythruna.client.net.ConnectToHostState;
import mythruna.client.net.HostSetupState;
import mythruna.client.net.NetworkState;
import mythruna.client.sound.SoundState;
import mythruna.world.WorldManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainMenuState
extends CompositeAppState {
    static Logger log = LoggerFactory.getLogger(MainMenuState.class);
    public static final String SOUND_MENU_MUSIC = "Main Menu Music";
    public static final String SOUND_MENU_AMBIENT = "Main Menu Ambient";
    public static final String SOUND_PAPER_CLICK = "Paper Click";
    public static final String SOUND_CLICK = "Short Click";
    private ConfigurationState config;
    private Container mainWindow;
    private Container help;
    private BaseAppState activeChild = null;
    private GameInfo lastGame = null;
    private boolean firstTime = true;

    public MainMenuState() {
        super(new AppState[0]);
        this.addChild((AppState)new WorldListState(), false);
        this.addChild((AppState)new CreateWorldState(), false);
        this.addChild((AppState)new HostSetupState(), false);
        this.addChild((AppState)new ConnectToHostState(), false);
    }

    public void messagePopup(String title, String message) {
        log.info("Popup GUI size:" + ((PopupState)this.getState(PopupState.class)).getGuiSize());
        ((OptionPanelState)this.getState(OptionPanelState.class)).show(title, message, new Action[0]);
    }

    protected void singlePlayer() {
        log.info("singlePlayer()");
        WorldListState state = (WorldListState)this.getChild(WorldListState.class);
        this.activeChild = state;
        state.selectWorld("Single Player", new Command<WorldManager>(){

            public void execute(WorldManager info) {
                MainMenuState.this.startSinglePlayer(info);
            }
        });
    }

    protected void joinMultiplayer() {
        log.info("joinMultiplayer()");
        ((ConnectToHostState)this.getChild(ConnectToHostState.class)).setEnabled(true);
        this.setEnabled(false);
    }

    protected void hostMultiplayer() {
        log.info("hostMultiplayer()");
        WorldListState state = (WorldListState)this.getChild(WorldListState.class);
        this.activeChild = state;
        state.selectWorld("Select Host World", new Command<WorldManager>(){

            public void execute(WorldManager info) {
                MainMenuState.this.setupHosting(info);
            }
        });
    }

    protected void startSinglePlayer(WorldManager world) {
        log.info("startSinglePlayer(" + world + ")");
        try {
            ((NetworkState)this.getState(NetworkState.class)).startSinglePlayer(world, null);
            this.setEnabled(false);
        }
        catch (RuntimeException e) {
            log.error("Error starting single player game", (Throwable)e);
            ((GuiState)this.getState(GuiState.class)).showError("Error Starting Single Player", e.getMessage());
            new Thread(() -> world.close()).start();
        }
    }

    protected void continueSinglePlayer() {
        log.info("continueSinglePlayer():" + this.lastGame);
        if (this.lastGame == null) {
            return;
        }
        WorldManager world = ((WorldListState)this.getState(WorldListState.class)).loadWorld(this.lastGame.worldDir);
        this.startSinglePlayer(world);
    }

    protected void setupHosting(WorldManager world) {
        log.info("setupHosting(" + world + ")");
        try {
            ((HostSetupState)this.getState(HostSetupState.class)).setupHosting(world);
            this.setEnabled(false);
        }
        catch (RuntimeException e) {
            log.error("Error initializing hosting", (Throwable)e);
            ((GuiState)this.getState(GuiState.class)).showError("Error Initializing Hosting", e.getMessage());
            new Thread(() -> world.close()).start();
        }
    }

    protected void settings() {
        log.info("settings()");
        ((GameSettingsState)this.getState(GameSettingsState.class)).setEnabled(true);
    }

    protected void initialize(Application app) {
        this.config = (ConfigurationState)this.getState(ConfigurationState.class, true);
        this.lastGame = this.config.getGameInfo("lastGame");
        SoundState sounds = (SoundState)this.getState(SoundState.class, true);
        sounds.registerSound(SOUND_MENU_MUSIC, "Music/mythruna-theme-celtic.ogg");
        sounds.registerSound(SOUND_MENU_AMBIENT, "Sounds/Ambient/Fire_Logs_Burning_in_Grate_3.ogg");
        sounds.registerSound(SOUND_PAPER_CLICK, "Sounds/Effects/paper-small.wav");
        sounds.registerSound(SOUND_CLICK, "Sounds/Effects/ShortClick.wav");
        this.mainWindow = new Container(new ElementId("window"));
        Label title = (Label)this.mainWindow.addChild((Node)new Label(""), new Object[0]);
        title.setIcon((GuiComponent)new IconComponent("Interface/mythruna-title-smaller.png"));
        Vector3f pref = title.getPreferredSize();
        title.setPreferredSize(pref);
        Container menu = (Container)this.mainWindow.addChild((Node)new Container(), new Object[0]);
        if (this.lastGame != null) {
            menu.addChild((Node)new ActionButton((Action)new CallMethodAction("Continue Last World...", (Object)this, "continueSinglePlayer")), new Object[0]);
        }
        menu.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "singlePlayer")), new Object[0]);
        menu.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "joinMultiplayer")), new Object[0]);
        menu.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "hostMultiplayer")), new Object[0]);
        menu.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "settings")), new Object[0]);
        ActionButton exit = (ActionButton)this.mainWindow.addChild((Node)new ActionButton((Action)new CallMethodAction("Exit Game", (Object)app, "stop")), new Object[0]);
        exit.setInsets(new Insets3f(10.0f, 10.0f, 10.0f, 10.0f));
        ElementId helpId = new ElementId("help");
        this.help = new Container((GuiLayout)new BorderLayout(), helpId.child("window"));
        this.help.addChild((Node)new Label("To start a new game:\n1) Select 'Single Player...'\n2) Click 'Create New World'\n3) Enter a name and a numeric seed.\n4) Optionally click 'Preview'\n5) Click 'Generate'\n6) Click 'Create Character'\n7) Fill in the info and click 'Create'\n8) Select the character and press 'Play'", helpId.child("label")), new Object[0]);
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        SoundState sounds;
        Node gui = ((GuiState)this.getState(GuiState.class, true)).getGuiRoot();
        gui.attachChild((Spatial)this.mainWindow);
        GuiGlobals.getInstance().requestFocus((Spatial)this.mainWindow);
        gui.attachChild((Spatial)this.help);
        this.resetPosition();
        if (this.firstTime) {
            this.firstTime = false;
            this.getApplication().enqueue(() -> this.messagePopup("Warning: Engine Test Build", "WARNING: This is a test build and not a fully functional game.\n\nWhile the world data format is 99% stable, there are not yet any\nguarantees that the things you build will be compatible with the\nnext version of the engine.\n\nAlso, the world fractal will definitely change in a future version\nand make current terrain no longer 'fit' even if the data format\ndoesn't change.\n\nBuild cool things but remember that they may be locked to this engine version."));
        }
        if (!(sounds = (SoundState)this.getState(SoundState.class)).isPlaying(SOUND_MENU_MUSIC)) {
            sounds.playMusic(SOUND_MENU_MUSIC, 2.0f);
        }
        if (!sounds.isPlaying(SOUND_MENU_AMBIENT)) {
            sounds.playAmbient(SOUND_MENU_AMBIENT, 2.0f).setLooping(true);
        }
    }

    public void update(float tpf) {
        if (this.activeChild != null && !this.activeChild.isEnabled()) {
            GuiGlobals.getInstance().requestFocus((Spatial)this.mainWindow);
            this.activeChild = null;
        }
    }

    protected void onDisable() {
        this.mainWindow.removeFromParent();
        this.help.removeFromParent();
    }

    protected void resetPosition() {
        Vector2f screen = ((GuiState)this.getState(GuiState.class, true)).getGuiSize();
        Vector3f pref = this.mainWindow.getPreferredSize().clone().mult(this.mainWindow.getLocalScale().x);
        float y = screen.y * 0.6f + pref.y * 0.5f;
        this.mainWindow.setLocalTranslation(100.0f, y, 0.0f);
        pref = this.help.getPreferredSize();
        this.help.setLocalTranslation(screen.x - pref.x - 10.0f, screen.y - 10.0f, 0.0f);
    }
}

