/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.net;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.DefaultRangedValueModel;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.RangedValueModel;
import com.simsilica.lemur.SequenceModels;
import com.simsilica.lemur.Spinner;
import com.simsilica.lemur.TextField;
import com.simsilica.lemur.ValueEditor;
import com.simsilica.lemur.ValueEditors;
import com.simsilica.lemur.ValueRenderer;
import com.simsilica.lemur.ValueRenderers;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.lemur.value.DefaultValueRenderer;
import java.net.InetAddress;
import java.net.URL;
import java.nio.charset.Charset;
import mythruna.client.GuiState;
import mythruna.client.MainMenuState;
import mythruna.client.ProgressState;
import mythruna.client.net.NetworkState;
import mythruna.world.WorldManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostSetupState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(HostSetupState.class);
    private static String[] HELP = new String[]{"Setting up your server:", "", "Set the port that users will use to connect to your", "server and the description that will be presented to", "them.", "", "Internet users will connect to your server at:", "Host: #internetAddress", "Port: #basePort", "", "For internet users, make sure your internet firewall", "directs ports #basePort - #maxPort", "to IP address: #localAddress", ""};
    private WorldManager world;
    private Vector2f guiSize;
    private Container window;
    private Label title;
    private Spinner<Double> port;
    private TextField description;
    private Container helpWindow;
    private Label help;
    private String ipRestUrl = "https://api.ipify.org";
    private boolean addressFound;
    private VersionedHolder<String> localAddress = new VersionedHolder((Object)"Unknown");
    private VersionedHolder<String> internetAddress = new VersionedHolder((Object)"Unknown");
    private VersionedReference<String> ipRef = this.internetAddress.createReference();
    private VersionedReference<Double> portRef;

    public HostSetupState() {
        this.setEnabled(false);
    }

    public void setupHosting(WorldManager world) {
        this.world = world;
        this.title.setText("Setup Hosting for:" + world.getInfo().getName());
        this.setEnabled(true);
    }

    protected void startHosting() {
        Double p = (Double)this.port.getValue();
        if (p == null || p.intValue() < 1 || p.intValue() >= 65535) {
            ((GuiState)this.getState(GuiState.class)).showError("Bad Port", "Please specify a valid port number\nbetween 1 and 65535");
            return;
        }
        ((NetworkState)this.getState(NetworkState.class)).startHosting(this.world, p.intValue(), this.description.getText());
        this.world = null;
        this.setEnabled(false);
    }

    public void cancel() {
        if (this.world != null) {
            ProgressState.ProgressTracker tracker = ((ProgressState)this.getState(ProgressState.class)).createTracker("worldShutdown", "Closing world...");
            new Thread(() -> {
                try {
                    this.world.close();
                    this.world = null;
                    this.getApplication().enqueue(() -> this.back());
                }
                finally {
                    tracker.close();
                }
            }).start();
        }
    }

    protected void back() {
        this.setEnabled(false);
        ((MainMenuState)this.getState(MainMenuState.class)).setEnabled(true);
    }

    public int getPort() {
        Double val = (Double)this.port.getValue();
        if (val == null) {
            return 4234;
        }
        return val.intValue();
    }

    protected void resetHelp() {
        String s = String.join((CharSequence)"\n", HELP);
        s = s.replaceAll("#internetAddress", (String)this.internetAddress.getObject());
        s = s.replaceAll("#localAddress", (String)this.localAddress.getObject());
        s = s.replaceAll("#basePort", String.valueOf(this.getPort()));
        s = s.replaceAll("#maxPort", String.valueOf(this.getPort() + 4));
        this.help.setText(s);
    }

    protected void fetchInternetAddress() {
        if (this.addressFound) {
            return;
        }
        try {
            URL u = new URL(this.ipRestUrl);
            String internet = Resources.toString((URL)u, (Charset)Charsets.UTF_8);
            log.info("Retrieved public address:" + internet);
            this.getApplication().enqueue(() -> this.internetAddress.setObject((Object)internet));
            this.addressFound = true;
        }
        catch (Exception e) {
            log.error("Error fetching internet addresses from:" + this.ipRestUrl, (Throwable)e);
            this.getApplication().enqueue(() -> this.internetAddress.setObject((Object)"ERROR"));
        }
    }

    protected void fetchLocalAddress() {
        try {
            String local = InetAddress.getLocalHost().getHostAddress();
            log.info("Retrieved local address:" + local);
            this.localAddress.setObject((Object)local);
        }
        catch (Exception e) {
            log.error("Error fetching local IP address", (Throwable)e);
            this.localAddress.setObject((Object)"ERROR");
        }
    }

    protected void initialize(Application app) {
        this.fetchLocalAddress();
        this.window = new Container(new ElementId("window"));
        this.title = (Label)this.window.addChild((Node)new Label("Host World", new ElementId("window.title")), new Object[0]);
        Container properties = (Container)this.window.addChild((Node)new Container(), new Object[0]);
        properties.addChild((Node)new Label("Port:"), new Object[0]);
        DefaultRangedValueModel range = new DefaultRangedValueModel(1.0, 65535.0, 4234.0);
        DefaultValueRenderer renderer = ValueRenderers.formattedRenderer((String)"%.0f", (String)"error");
        this.port = (Spinner)properties.addChild((Node)new Spinner(SequenceModels.rangedSequence((RangedValueModel)range, (double)1.0, (double)1.0), (ValueRenderer)renderer), new Object[]{1});
        this.port.setValueEditor((ValueEditor)ValueEditors.doubleEditor((String)"%.0f"));
        this.portRef = this.port.getModel().createReference();
        this.window.addChild((Node)new Label("Server Description:"), new Object[0]);
        this.description = (TextField)this.window.addChild((Node)new TextField("This is my server."), new Object[0]);
        this.description.setSingleLine(false);
        this.description.setPreferredLineCount(5);
        this.description.setPreferredWidth(375.0f);
        this.window.addChild((Node)new Label("Additional settings would go here.\n\n\n"), new Object[0]);
        Container buttons = (Container)this.window.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y)), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "startHosting")), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "cancel")), new Object[0]);
        ElementId helpId = new ElementId("help");
        this.helpWindow = new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.Last, FillMode.Even), helpId.child("window"));
        this.helpWindow.addChild((Node)new Label("Help", helpId.child("title")), new Object[0]);
        this.help = (Label)this.helpWindow.addChild((Node)new Label("This is where help goes.", helpId.child("label")), new Object[0]);
        this.resetHelp();
    }

    protected void cleanup(Application app) {
        if (this.world != null) {
            log.warn("Closing world that was left open:" + this.world);
            this.world.close();
        }
    }

    protected void onEnable() {
        if (!this.addressFound) {
            new Thread(() -> this.fetchInternetAddress()).start();
        }
        GuiGlobals globals = GuiGlobals.getInstance();
        this.guiSize = globals.getPopupState().getGuiSize();
        globals.getPopupState().centerInGui((Spatial)this.window);
        globals.getPopupState().showModalPopup((Spatial)this.window, new ColorRGBA(0.0f, 0.0f, 0.0f, 0.5f));
        globals.getPopupState().getGuiNode().attachChild((Spatial)this.helpWindow);
        globals.requestFocus((Spatial)this.window);
    }

    protected void onDisable() {
        this.window.removeFromParent();
        this.helpWindow.removeFromParent();
    }

    public void update(float tpf) {
        boolean helpChanged = false;
        if (this.portRef.update()) {
            helpChanged = true;
        }
        if (this.ipRef.update()) {
            helpChanged = true;
        }
        if (helpChanged) {
            this.resetHelp();
        }
        Vector3f size = this.window.getSize();
        Vector3f helpSize = this.helpWindow.getSize();
        float width = helpSize.x + size.x;
        Vector3f loc = this.window.getLocalTranslation();
        loc.x = this.guiSize.x * 0.5f - width * 0.5f;
        this.window.setLocalTranslation(loc);
        this.helpWindow.setLocalTranslation(loc.x + size.x + 50.0f, loc.y + (helpSize.y - size.y) * 0.5f, loc.z);
    }
}

