#import "Common/ShaderLib/GLSLCompat.glsllib"
#import "Common/ShaderLib/Instancing.glsllib"

uniform vec2 m_TextureOffset;

attribute vec3 inPosition;
attribute vec2 inTexCoord;

varying vec2 texCoord1;

void main(){
    texCoord1 = inTexCoord;

    // y-flip the texture
    texCoord1.y = 1.0 - texCoord1.y;

    texCoord1 += m_TextureOffset;

    vec4 modelSpacePos = vec4(inPosition, 1.0);

    gl_Position = TransformWorldViewProjection(modelSpacePos);
}
