/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim;

import com.google.common.base.Function;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.ext.mphys.MPhysSystem;
import com.simsilica.mblock.phys.MBlockShape;
import com.simsilica.mphys.ControlDriver;
import com.simsilica.mphys.PhysicsSpace;
import com.simsilica.mphys.RigidBody;
import com.simsilica.sim.AbstractGameSystem;
import com.simsilica.sim.SimTime;
import mythruna.es.MovementInput;
import mythruna.es.VehicleInput;
import mythruna.sim.PlayerDriver;
import mythruna.sim.VehicleDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MovementSystem
extends AbstractGameSystem {
    static Logger log = LoggerFactory.getLogger(MovementSystem.class);
    private EntityData ed;
    private MPhysSystem<MBlockShape> physics;
    private PlayerContainer players;
    private VehicleContainer vehicles;
    private MovementBodyInitializer initializer = new MovementBodyInitializer();
    private PhysicsSpace<EntityId, MBlockShape> space;

    public RigidBody<EntityId, MBlockShape> getBody(EntityId id) {
        return this.space.getBinIndex().getRigidBody((Object)id);
    }

    protected void initialize() {
        this.ed = (EntityData)this.getSystem(EntityData.class);
        if (this.ed == null) {
            throw new RuntimeException(((Object)((Object)this)).getClass().getName() + " system requires an EntityData object.");
        }
        this.physics = (MPhysSystem)this.getSystem(MPhysSystem.class);
        if (this.physics == null) {
            throw new RuntimeException(((Object)((Object)this)).getClass().getName() + " system requires the MPhysSystem system.");
        }
        this.space = this.physics.getPhysicsSpace();
        this.physics.getBodyFactory().addDynamicInitializer((Function)this.initializer);
    }

    protected void terminate() {
    }

    public void start() {
        this.players = new PlayerContainer(this.ed);
        this.vehicles = new VehicleContainer(this.ed);
        this.players.start();
        this.vehicles.start();
    }

    public void update(SimTime time) {
        this.players.update();
        this.vehicles.update();
    }

    public void stop() {
        this.players.stop();
        this.players = null;
        this.vehicles.stop();
        this.vehicles = null;
    }

    private class VehicleContainer
    extends EntityContainer<VehicleDriver> {
        public VehicleContainer(EntityData ed) {
            super(ed, new Class[]{VehicleInput.class});
        }

        public VehicleDriver[] getArray() {
            return (VehicleDriver[])super.getArray();
        }

        protected VehicleDriver addObject(Entity e) {
            log.info("Vehicles.addObject(" + e + ")");
            VehicleDriver result = new VehicleDriver(MovementSystem.this.ed, e.getId());
            RigidBody body = MovementSystem.this.space.getBinIndex().getRigidBody((Object)e.getId());
            log.info("Vehicles.existing body:" + body);
            if (body != null) {
                body.setControlDriver((ControlDriver)result);
                body.wakeUp();
            }
            return result;
        }

        protected void updateObject(VehicleDriver driver, Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("updateObject(" + e + ")");
            }
            VehicleInput ms = (VehicleInput)e.get(VehicleInput.class);
            driver.applyVehicleInput(ms);
        }

        protected void removeObject(VehicleDriver driver, Entity e) {
            log.info("Vehicles.removeObject(" + e + ")");
        }
    }

    private class PlayerContainer
    extends EntityContainer<PlayerDriver> {
        public PlayerContainer(EntityData ed) {
            super(ed, new Class[]{MovementInput.class});
        }

        public PlayerDriver[] getArray() {
            return (PlayerDriver[])super.getArray();
        }

        protected PlayerDriver addObject(Entity e) {
            log.info("addObject(" + e + ")");
            PlayerDriver result = new PlayerDriver(MovementSystem.this.ed, e.getId());
            RigidBody body = MovementSystem.this.space.getBinIndex().getRigidBody((Object)e.getId());
            log.info("existing body:" + body);
            if (body != null) {
                body.setControlDriver((ControlDriver)result);
                body.wakeUp();
            }
            return result;
        }

        protected void updateObject(PlayerDriver driver, Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("updateObject(" + e + ")");
            }
            MovementInput ms = (MovementInput)e.get(MovementInput.class);
            driver.applyMovementInput(ms);
        }

        protected void removeObject(PlayerDriver driver, Entity e) {
            log.info("removeObject(" + e + ")");
        }
    }

    private class MovementBodyInitializer
    implements Function<RigidBody<EntityId, MBlockShape>, Void> {
        private MovementBodyInitializer() {
        }

        public Void apply(RigidBody<EntityId, MBlockShape> body) {
            PlayerDriver driver = (PlayerDriver)((Object)MovementSystem.this.players.getObject((EntityId)body.id));
            log.info("MovementBodyInitializer.apply(" + body + ")  driver:" + (Object)((Object)driver));
            if (driver != null) {
                body.setControlDriver((ControlDriver)driver);
            }
            VehicleDriver driver2 = (VehicleDriver)((Object)MovementSystem.this.vehicles.getObject((EntityId)body.id));
            log.info("MovementBodyInitializer.apply(" + body + ")  driver2:" + (Object)((Object)driver2));
            if (driver2 != null) {
                body.setControlDriver((ControlDriver)driver2);
            }
            return null;
        }
    }
}

