/*
 * Decompiled with CFR 0.152.
 */
package mythruna.server;

import com.simsilica.event.EventBus;
import com.simsilica.event.EventType;
import com.simsilica.sim.SimEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import mythruna.server.GameServer;
import mythruna.server.ServerConfig;
import mythruna.world.WorldInfo;
import mythruna.world.WorldLibrary;
import mythruna.world.WorldManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerLauncher {
    static Logger log = LoggerFactory.getLogger(ServerLauncher.class);
    public static final String[] HELP = new String[]{"Mythruna-server [-init] <server name>", "", "Where:", "  [-init] - specifies that a new server config should be initialized", "            with the specified server name.", "  <server name> - The name of the server to load if already initialized", "            or to initialize if running -init mode.", "            The server name is used to look for a server name.config", "            file that contains the server settings, world info, etc..", "            -init will create this file."};
    private ServerConfig config;
    private WorldManager world;
    private GameServer server;

    public ServerLauncher(ServerConfig config) {
        this.config = config;
    }

    public void initialize() {
        WorldLibrary library = new WorldLibrary(this.config.getWorldLibrary());
        WorldInfo info = library.loadWorldInfo(this.config.getWorldDir());
        log.info("Loading world:" + info);
        this.world = WorldManager.loadWorld((WorldInfo)info);
        this.world.getModManager().setGlobalBinding("singlePlayer", (Object)false);
    }

    public void start() {
        log.info("start()");
        EventBus.addListener((Object)this, (EventType[])new EventType[]{SimEvent.simFailed});
        try {
            this.server = new GameServer(this.world, null, null, this.config.getPort(), this.config.getServerDescription());
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating game server", e);
        }
        this.server.start();
    }

    public void stop() {
        if (this.server == null) {
            return;
        }
        log.info("stop()");
        EventBus.removeListener((Object)this, (EventType[])new EventType[]{SimEvent.simFailed});
        this.server.close("Server is shutting own.");
        this.server = null;
    }

    public void logStats() {
        this.server.logStats();
    }

    public void terminate() {
        log.info("terminate()");
        this.world.close();
    }

    protected void simFailed(SimEvent event) {
        log.info("Simulation failed to start:" + event);
    }

    protected void execute(String cmd) {
        try {
            Object result = this.server.getAdminShell().execute(cmd);
            if (result != null) {
                log.info("result:" + result);
            }
        }
        catch (Exception e) {
            log.error("Error executing:" + cmd, (Throwable)e);
        }
    }

    public static void print(String ... lines) {
        for (String l : lines) {
            System.out.println(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String ... args) throws Exception {
        log.info("Mythruna Server Launcher");
        if (args.length == 0) {
            ServerLauncher.print(HELP);
            return;
        }
        StringBuilder sb = new StringBuilder();
        boolean init = false;
        for (String s : args) {
            if (s.equals("-init")) {
                init = true;
                continue;
            }
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(s);
        }
        String serverName = sb.toString();
        if (init) {
            log.info("Initializing server:" + serverName);
            ServerConfig config = ServerConfig.getInstance(serverName, init);
            log.info("To setup the server, edit file:" + config.getConfigFile());
            return;
        }
        ServerConfig config = ServerConfig.getInstance(serverName, false);
        log.info("Running server with config:" + config.getConfigFile());
        ServerLauncher launcher = new ServerLauncher(config);
        launcher.initialize();
        try {
            String line;
            log.info("Starting server...");
            launcher.start();
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            while ((line = in.readLine()) != null) {
                if (line.length() == 0) continue;
                if ("exit".equals(line)) break;
                if ("stats".equals(line)) {
                    launcher.logStats();
                    continue;
                }
                launcher.execute(line);
            }
            log.info("Stopping server...");
            launcher.stop();
        }
        finally {
            launcher.terminate();
        }
    }
}

