/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.sound;

import com.jme3.audio.AudioNode;
import com.jme3.audio.AudioSource;
import java.util.function.Supplier;
import mythruna.client.sound.SoundType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sound {
    static Logger log = LoggerFactory.getLogger(Sound.class);
    private SoundType type;
    private String name;
    private boolean looping;
    private AudioNode player;
    private float volume = 1.0f;
    private float baseVolume;
    private Supplier<AudioNode> factory;

    public Sound(SoundType type, String name, boolean looping, Supplier<AudioNode> factory) {
        this.type = type;
        this.name = name;
        this.looping = looping;
        this.factory = factory;
    }

    public String getName() {
        return this.name;
    }

    public SoundType getType() {
        return this.type;
    }

    public void setBaseVolume(float baseVolume) {
        if (log.isTraceEnabled()) {
            log.trace("setBaseVolume(" + baseVolume + ")");
        }
        this.baseVolume = baseVolume;
        this.resetVolume();
    }

    protected void resetVolume() {
        if (this.player != null) {
            this.player.setVolume(this.baseVolume * this.volume);
        }
    }

    public float getBaseVolume() {
        return this.baseVolume;
    }

    public Sound setVolume(float volume) {
        if (log.isTraceEnabled()) {
            log.trace("setVolume(" + volume + ")");
        }
        this.volume = volume;
        this.resetVolume();
        return this;
    }

    public float getVolume() {
        return this.volume;
    }

    public Sound setLooping(boolean looping) {
        this.looping = looping;
        return this;
    }

    public boolean isLooping() {
        return this.looping;
    }

    protected AudioNode getPlayer() {
        if (this.player == null) {
            this.player = this.factory.get();
            if (log.isTraceEnabled()) {
                log.trace("player created, setting volume to:" + this.volume);
            }
            this.resetVolume();
        }
        return this.player;
    }

    public void play() {
        if (log.isTraceEnabled()) {
            log.trace("play()");
        }
        AudioNode player = this.getPlayer();
        log.info("playing:" + this.name + "  baseVolume:" + this.baseVolume + "  volume:" + this.volume);
        player.setVolume(this.baseVolume * this.volume);
        player.play();
        log.info("setting volume to:" + this.baseVolume * this.volume);
        player.setVolume(this.baseVolume * this.volume);
    }

    public boolean isPlaying() {
        if (this.player == null) {
            return false;
        }
        return this.player.getStatus() == AudioSource.Status.Playing;
    }

    public void stop() {
        if (this.player != null) {
            this.player.stop();
            this.player = null;
        }
    }

    public void update() {
        if (this.player == null) {
            return;
        }
        if (this.player.getStatus() == AudioSource.Status.Stopped) {
            this.player = null;
            if (this.looping) {
                if (log.isTraceEnabled()) {
                    log.trace("restarting");
                }
                this.play();
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[type:" + (Object)((Object)this.type) + ", looping:" + this.looping + ", factory:" + this.factory + "]";
    }
}

