/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui;

import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.app.state.BaseAppState;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Quad;
import com.jme3.texture.Texture;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Name;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.component.BorderLayout;
import com.simsilica.lemur.component.QuadBackgroundComponent;
import com.simsilica.lemur.core.GuiComponent;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.view.FarTerrainState;
import mythruna.client.GuiState;
import mythruna.client.net.ConnectionState;
import mythruna.client.ui.MapComponent;
import mythruna.client.ui.PlayerMenuState;
import mythruna.client.view.AvatarState;
import mythruna.net.AccountSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapViewState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(MapViewState.class);
    private EntityData ed;
    private Container mapContainer;
    private Container left;
    private Container right;
    private Label map;
    private MapComponent mapComponent;
    private Node playerMarker;
    private VersionedReference<Vec3d> posRef;
    private VersionedReference<Quatd> orientRef;

    public MapViewState() {
        this.setEnabled(false);
    }

    public Container getMap() {
        return this.mapContainer;
    }

    protected void initialize(Application app) {
        float sizeDelta;
        this.ed = ((ConnectionState)this.getState(ConnectionState.class, true)).getEntityData();
        ((PlayerMenuState)this.getState(PlayerMenuState.class, true)).addSubmenu("Map", (AppState)this);
        this.mapContainer = new Container((GuiLayout)new BorderLayout(), new ElementId("popup"));
        this.left = (Container)this.mapContainer.addChild((Node)new Container(), new Object[]{BorderLayout.Position.West});
        this.right = (Container)this.mapContainer.addChild((Node)new Container(), new Object[]{BorderLayout.Position.East});
        Texture terrain = ((FarTerrainState)this.getState(FarTerrainState.class, true)).getFarTerrainTexture();
        Texture fluid = ((FarTerrainState)this.getState(FarTerrainState.class, true)).getFarFluidTexture();
        this.map = (Label)this.mapContainer.addChild((Node)new Label(""), new Object[]{BorderLayout.Position.Center});
        Texture paper = app.getAssetManager().loadTexture("Textures/sand.jpg");
        this.map.setBackground((GuiComponent)new QuadBackgroundComponent(paper));
        this.mapComponent = new MapComponent(app.getAssetManager(), terrain, fluid);
        this.map.setIcon((GuiComponent)this.mapComponent);
        AccountSession account = ((ConnectionState)this.getState(ConnectionState.class, true)).getService(AccountSession.class);
        EntityId worldEntity = account.getWorldEntity();
        Name name = (Name)this.ed.getComponent(worldEntity, Name.class);
        this.left.addChild((Node)new Label("TBD"), new Object[0]);
        this.right.addChild((Node)new Label("World:" + name.getName()), new Object[0]);
        this.posRef = ((AvatarState)this.getState(AvatarState.class)).createPositionReference();
        this.orientRef = ((AvatarState)this.getState(AvatarState.class)).createOrientationReference();
        this.playerMarker = new Node();
        Quad quad = new Quad(64.0f, 64.0f);
        Geometry geom = new Geometry("marker", (Mesh)quad);
        geom.setLocalScale(0.15f);
        Texture arrow = app.getAssetManager().loadTexture("Interface/arrow-right.png");
        geom.setMaterial(GuiGlobals.getInstance().createMaterial(arrow, false).getMaterial());
        geom.getMaterial().getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        geom.getMaterial().setColor("Color", new ColorRGBA(0.75f, 0.1f, 0.1f, 0.75f));
        geom.center();
        this.playerMarker.attachChild((Spatial)geom);
        this.playerMarker.setLocalTranslation(100.0f, -100.0f, 10.0f);
        this.map.attachChild((Spatial)this.playerMarker);
        Vector2f guiSize = ((GuiState)this.getState(GuiState.class)).getGuiSize();
        float scale = 1.0f;
        this.mapContainer.setLocalScale(scale);
        float mapSize = guiSize.y * 0.9f / scale;
        this.map.setPreferredSize(new Vector3f(mapSize, mapSize, 1.0f));
        float w = guiSize.x;
        float h = guiSize.y;
        float maxWidth = guiSize.x * 0.8f;
        float maxHeight = guiSize.y * 0.9f;
        float minWidth = guiSize.x * 0.7f;
        float minHeight = guiSize.y * 0.9f;
        Vector3f pref = this.mapContainer.getPreferredSize();
        pref = pref.mult(scale);
        float xDelta = 0.0f;
        float yDelta = 0.0f;
        if (pref.x > maxWidth) {
            xDelta = pref.x - maxWidth;
        }
        if (pref.y > maxHeight) {
            yDelta = pref.y - maxHeight;
        }
        if ((sizeDelta = Math.max(xDelta, yDelta)) > 0.0f) {
            this.map.setPreferredSize(new Vector3f(mapSize -= sizeDelta / scale, mapSize, 1.0f));
        }
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        log.info("onEnable()");
        ((GuiState)this.getState(GuiState.class)).center((Panel)this.mapContainer);
        this.mapContainer.move(0.0f, 0.0f, 10.0f);
        ((GuiState)this.getState(GuiState.class)).getGuiRoot().attachChild((Spatial)this.mapContainer);
    }

    protected void onDisable() {
        log.info("onDisable()");
        this.mapContainer.removeFromParent();
    }

    public void update(float tpf) {
        if (this.orientRef.update()) {
            this.updatePlayerMarker();
        }
        if (this.posRef.update()) {
            this.updateTextureOffset((Vec3d)this.posRef.get());
        }
    }

    protected void updateTextureOffset(Vec3d pos) {
        TileId tile = TileId.fromWorld((double)pos.x, (double)pos.z);
        Vec3d offset = pos.subtract(tile.getWorld(null).toVec3d());
        double x = offset.x / 16384.0;
        double z = offset.z / 16384.0;
        this.mapComponent.setTextureOffset(x -= 0.03125, z -= 0.03125);
    }

    protected void updatePlayerMarker() {
        Vector3f size = this.map.getSize();
        if (size.y > 0.0f) {
            float center = size.y * 0.5f;
            this.playerMarker.setLocalTranslation(center, -center, 10.0f);
        }
        Quatd orient = (Quatd)this.orientRef.get();
        Vec3d dir = orient.mult(Vec3d.UNIT_Z);
        double rads = Math.atan2(-dir.z, dir.x);
        this.playerMarker.setLocalRotation(new Quaternion().fromAngles(0.0f, 0.0f, (float)rads));
    }
}

