/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.DefaultRangedValueModel;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.RangedValueModel;
import com.simsilica.lemur.SequenceModel;
import com.simsilica.lemur.SequenceModels;
import com.simsilica.lemur.Spinner;
import com.simsilica.lemur.ValueEditor;
import com.simsilica.lemur.ValueEditors;
import com.simsilica.lemur.ValueRenderer;
import com.simsilica.lemur.ValueRenderers;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.input.InputMapper;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.lemur.value.DefaultValueRenderer;
import com.simsilica.state.GameSystemsState;
import mythruna.client.GameSessionState;
import mythruna.client.GuiState;
import mythruna.client.MainGameFunctions;
import mythruna.client.net.ConnectionState;
import mythruna.client.net.HostedGameState;
import mythruna.client.net.TimeState;
import mythruna.net.AccountSession;
import mythruna.world.WorldTime;
import mythruna.world.WorldTimeSource;
import mythruna.world.es.WorldAge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorldTimeState
extends BaseAppState
implements WorldTimeSource {
    static Logger log = LoggerFactory.getLogger(WorldTimeState.class);
    private TimeState timeState;
    private EntityData ed;
    private EntityId worldEntity;
    private WorldTime worldTime;
    private WorldTime hostWorldTime;
    private boolean paused;
    private long pauseTime;
    private Container window;
    private Action pauseAction;
    private Spinner<Double> year;
    private Spinner<Double> month;
    private Spinner<Double> day;
    private Spinner<Double> hour;
    private Spinner<Double> minute;
    private VersionedReference<Double> yearRef;
    private VersionedReference<Double> monthRef;
    private VersionedReference<Double> dayRef;
    private VersionedReference<Double> hourRef;
    private VersionedReference<Double> minuteRef;

    public long getSimTime() {
        return this.worldTime.getRealTimeNanos();
    }

    public double getGameTime() {
        return this.worldTime.getGameTime();
    }

    public WorldTime getWorldTime() {
        return this.worldTime.clone();
    }

    public WorldTime getWorldTimeSource() {
        return this.worldTime;
    }

    protected void initialize(Application app) {
        this.timeState = (TimeState)this.getState(TimeState.class, true);
        this.ed = ((ConnectionState)this.getState(ConnectionState.class, true)).getEntityData();
        this.worldTime = (WorldTime)((GameSystemsState)this.getState(GameSystemsState.class, true)).get(WorldTime.class);
        HostedGameState host = (HostedGameState)this.getState(HostedGameState.class);
        if (host != null && host.isSinglePlayer()) {
            this.hostWorldTime = (WorldTime)host.getSystems().get(WorldTime.class);
            log.info("Found host worldTime:" + this.hostWorldTime);
        }
        AccountSession as = ((ConnectionState)this.getState(ConnectionState.class, true)).getService(AccountSession.class);
        this.worldEntity = as.getWorldEntity();
        WorldAge offset = (WorldAge)this.ed.getComponent(this.worldEntity, WorldAge.class);
        if (offset != null) {
            log.info("Setting base offset to:" + offset.getAge());
            this.worldTime.setBaseOffset(offset.getAge());
        } else {
            log.warn("No offset time for world entity:" + this.worldEntity);
        }
        if (((GameSessionState)this.getState(GameSessionState.class)).isSinglePlayer()) {
            this.createSettingsWindow();
        }
    }

    protected void createSettingsWindow() {
        this.window = new Container(new ElementId("window"));
        this.window.addChild((Node)new Label("Time Debug", new ElementId("title.label")), new Object[0]);
        Container props = (Container)this.window.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y)), new Object[0]);
        props.addChild((Node)new Label("", new ElementId("time.label")), new Object[0]);
        this.pauseAction = new CallMethodAction("Pause", (Object)this, "togglePause");
        props.addChild((Node)new ActionButton(this.pauseAction), new Object[]{1});
        props.addChild((Node)new Label("Year", new ElementId("time.label")), new Object[0]);
        this.year = (Spinner)props.addChild(this.createSpinner(1, 2000, 1), new Object[]{1});
        this.yearRef = this.year.getModel().createReference();
        props.addChild((Node)new Label("Month", new ElementId("time.label")), new Object[0]);
        this.month = (Spinner)props.addChild(this.createSpinner(0, 13, 1), new Object[]{1});
        this.monthRef = this.month.getModel().createReference();
        props.addChild((Node)new Label("Day", new ElementId("time.label")), new Object[0]);
        this.day = (Spinner)props.addChild(this.createSpinner(0, 29, 1), new Object[]{1});
        this.dayRef = this.day.getModel().createReference();
        props.addChild((Node)new Label("Hour", new ElementId("time.label")), new Object[0]);
        this.hour = (Spinner)props.addChild(this.createSpinner(-1, 24, 1), new Object[]{1});
        this.hourRef = this.hour.getModel().createReference();
        props.addChild((Node)new Label("Min.", new ElementId("time.label")), new Object[0]);
        this.minute = (Spinner)props.addChild(this.createSpinner(-1, 60, 1), new Object[]{1});
        this.minuteRef = this.minute.getModel().createReference();
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.addDelegate(MainGameFunctions.F_TIME_DEBUG, (Object)this, "toggleTimeDebug");
    }

    public void toggleTimeDebug() {
        log.info("toggleTimeDebug()");
        if (this.window.getParent() == null) {
            Vector3f pref = this.window.getPreferredSize();
            Vector2f guiSize = ((GuiState)this.getState(GuiState.class)).getGuiSize();
            this.window.setLocalTranslation(guiSize.x - pref.x, pref.y, 0.0f);
            GuiGlobals.getInstance().getPopupState().showPopup((Spatial)this.window);
            ((GameSessionState)this.getState(GameSessionState.class)).openMiscPopup((Spatial)this.window);
        } else {
            ((GameSessionState)this.getState(GameSessionState.class)).closeMiscPopup();
        }
    }

    protected void togglePause() {
        log.info("togglePause()");
        if (this.paused) {
            log.info("Resuming time...");
            this.paused = false;
            long offset = this.timeState.getTime() - this.pauseTime;
            offset = this.worldTime.getBaseOffset() - offset;
            this.worldTime.setBaseOffset(offset);
            this.pauseAction.setName("Pause");
        } else {
            log.info("Pausing time...");
            this.paused = true;
            this.pauseTime = this.timeState.getTime();
            this.pauseAction.setName("Resume");
        }
    }

    protected void cleanup(Application app) {
        if (this.window != null) {
            InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
            inputMapper.removeDelegate(MainGameFunctions.F_TIME_DEBUG, (Object)this, "toggleTimeDebug");
        }
    }

    protected void onEnable() {
    }

    protected void onDisable() {
    }

    public void update(float tpf) {
        if (this.window != null) {
            long after;
            long before = this.worldTime.getBaseOffset();
            if (this.yearRef.update()) {
                log.info("year has changed");
                this.worldTime.setYear((int)((Double)this.yearRef.get()).doubleValue());
            }
            if (this.monthRef.update()) {
                log.info("month has changed");
                this.worldTime.setMonth((int)((Double)this.monthRef.get()).doubleValue() - 1);
            }
            if (this.dayRef.update()) {
                log.info("day has changed");
                this.worldTime.setDay((int)((Double)this.dayRef.get()).doubleValue() - 1);
            }
            if (this.hourRef.update()) {
                log.info("hour has changed");
                this.worldTime.setHour((int)((Double)this.hourRef.get()).doubleValue());
            }
            if (this.minuteRef.update()) {
                log.info("minute has changed");
                this.worldTime.setMinute((int)((Double)this.minuteRef.get()).doubleValue());
            }
            if ((after = this.worldTime.getBaseOffset()) != before) {
                this.baseOffsetChanged(before, after);
            }
        }
        if (!this.paused) {
            this.worldTime.setRealTimeNanos(this.timeState.getTime());
            if (this.window != null) {
                this.updateFields(this.worldTime);
            }
        }
    }

    protected void updateFields(WorldTime time) {
        this.year.setValue((Object)time.getYear());
        this.month.setValue((Object)(time.getMonth() + 1));
        this.day.setValue((Object)(time.getDay() + 1));
        this.hour.setValue((Object)time.getHour());
        this.minute.setValue((Object)time.getMinute());
        this.yearRef.update();
        this.monthRef.update();
        this.dayRef.update();
        this.hourRef.update();
        this.minuteRef.update();
    }

    protected void baseOffsetChanged(long before, long after) {
        if (this.hostWorldTime != null) {
            long base = this.hostWorldTime.getBaseOffset();
            this.hostWorldTime.setBaseOffset(base += after - before);
        }
    }

    protected Spinner<Double> createSpinner(int min, int max, int step) {
        SequenceModel model = SequenceModels.rangedSequence((RangedValueModel)new DefaultRangedValueModel((double)min, (double)max, 0.0), (double)step, (double)1.0);
        int digits = 2;
        if (max - min + 1 > 100) {
            digits = 4;
        }
        String format = "%0" + digits + ".0f";
        DefaultValueRenderer renderer = ValueRenderers.formattedRenderer((String)format, (String)"error");
        Spinner result = new Spinner(model, (ValueRenderer)renderer);
        result.setValueEditor((ValueEditor)ValueEditors.doubleEditor((String)format));
        return result;
    }
}

