/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Checkbox;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.DefaultRangedValueModel;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.RangedValueModel;
import com.simsilica.lemur.Slider;
import com.simsilica.lemur.TabbedPanel;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.props.PropertyPanel;
import com.simsilica.lemur.style.ElementId;
import mythruna.client.GameSessionState;
import mythruna.client.GuiState;
import mythruna.client.MythrunaConfig;
import mythruna.client.PostProcessingState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GameSettingsState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(GameSettingsState.class);
    private Container window;
    private TabbedPanel tabs;
    private PropertyPanel rendering;
    private Container debugPanel;
    private boolean centered = true;
    private VersionedReference<TabbedPanel.Tab> currentTabRef;
    private VersionedHolder<Boolean> invertY = new VersionedHolder((Object)Boolean.FALSE);
    private Checkbox mute;
    private Slider music;
    private Slider effects;
    private Slider ambient;

    public GameSettingsState() {
        this.setEnabled(false);
    }

    public void setCentered(boolean centered) {
        if (this.centered == centered) {
            return;
        }
        this.centered = centered;
        this.resetPosition();
    }

    public boolean isCentered() {
        return this.centered;
    }

    public Container getDebugPanel() {
        return this.debugPanel;
    }

    public void setInvertY(boolean f) {
        this.invertY.setObject((Object)f);
    }

    public boolean getInvertY() {
        return (Boolean)this.invertY.getObject();
    }

    public VersionedReference<Boolean> createInvertYRef() {
        return this.invertY.createReference();
    }

    public VersionedReference<Boolean> createMuteReference() {
        return this.mute.getModel().createReference();
    }

    public VersionedReference<Double> createMusicVolumeReference() {
        return this.music.getModel().createReference();
    }

    public VersionedReference<Double> createEffectsVolumeReference() {
        return this.effects.getModel().createReference();
    }

    public VersionedReference<Double> createAmbientVolumeReference() {
        return this.ambient.getModel().createReference();
    }

    protected void back() {
        if (this.getState(GameSessionState.class) != null) {
            ((GameSessionState)this.getState(GameSessionState.class)).trigger("returnToGame");
        } else {
            this.setEnabled(false);
        }
    }

    protected void initialize(Application app) {
        MythrunaConfig config = MythrunaConfig.getInstance();
        this.window = new Container(new ElementId("window"));
        this.tabs = (TabbedPanel)this.window.addChild((Node)new TabbedPanel(), new Object[0]);
        this.currentTabRef = this.tabs.getSelectionModel().createReference();
        this.window.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "back")), new Object[0]);
        PropertyPanel props = (PropertyPanel)this.tabs.addTab("Controls", (Panel)new PropertyPanel(null));
        props.addBooleanProperty("Invert Y", (Object)this, "invertY");
        Container sound = (Container)this.tabs.addTab("Sound", (Panel)new Container());
        this.mute = (Checkbox)sound.addChild((Node)new Checkbox("Mute"), new Object[0]);
        Boolean allMuted = config.getStartupSetting("SoundState.muted", Boolean.FALSE);
        this.mute.setChecked(allMuted.booleanValue());
        sound.addChild((Node)new Label("Volume:"), new Object[0]);
        Container volumes = (Container)sound.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.Last, FillMode.Last)), new Object[0]);
        volumes.addChild((Node)new Label("Music:"), new Object[0]);
        double musicVolume = config.getStartupSetting("SoundState.musicVolume", 50.0);
        this.music = (Slider)volumes.addChild((Node)new Slider((RangedValueModel)new DefaultRangedValueModel(0.0, 100.0, musicVolume)), new Object[]{1});
        volumes.addChild((Node)new Label("Effects:"), new Object[0]);
        double effectsVolume = config.getStartupSetting("SoundState.effectsVolume", 75.0);
        this.effects = (Slider)volumes.addChild((Node)new Slider((RangedValueModel)new DefaultRangedValueModel(0.0, 100.0, effectsVolume)), new Object[]{1});
        volumes.addChild((Node)new Label("Ambient:"), new Object[0]);
        double ambientVolume = config.getStartupSetting("SoundState.ambientVolume", 75.0);
        this.ambient = (Slider)volumes.addChild((Node)new Slider((RangedValueModel)new DefaultRangedValueModel(0.0, 100.0, ambientVolume)), new Object[]{1});
        this.rendering = (PropertyPanel)this.tabs.addTab("Rendering", (Panel)new PropertyPanel(null));
        PostProcessingState post = (PostProcessingState)this.getState(PostProcessingState.class, true);
        post.setEnabled(config.getStartupSetting("PostProcessingState.enabled", true));
        this.rendering.getContainer().addChild((Node)new Label("Post Processing:"), new Object[0]);
        this.rendering.addBooleanProperty("Enabled", (Object)post, "enabled");
        this.rendering.addFloatProperty("Bloom Intensity", (Object)post.getBloomFilter(), "bloomIntensity", 0.0f, 5.0f, 0.1f);
        this.rendering.addFloatProperty("Blur Scale", (Object)post.getBloomFilter(), "blurScale", 0.0f, 5.0f, 0.1f);
        this.rendering.addFloatProperty("Down Sampling", (Object)post.getBloomFilter(), "downSamplingFactor", 0.1f, 20.0f, 0.1f);
        this.rendering.addFloatProperty("Exposure Cut-off", (Object)post.getBloomFilter(), "exposureCutOff", 0.0f, 1.0f, 0.1f);
        this.rendering.addFloatProperty("Exposure Power", (Object)post.getBloomFilter(), "exposurePower", 0.0f, 10.0f, 0.1f);
        this.debugPanel = (Container)this.tabs.addTab("Debug", (Panel)new Container());
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        this.getApplication().enqueue(() -> {
            this.resetPosition();
            GuiGlobals.getInstance().getPopupState().showModalPopup((Spatial)this.window, new ColorRGBA(0.0f, 0.0f, 0.0f, 0.01f));
        });
    }

    public void update(float tpf) {
        if (this.currentTabRef.update()) {
            this.resetPosition();
        }
    }

    protected void onDisable() {
        this.window.removeFromParent();
    }

    protected void resetPosition() {
        log.info("resetPosition() centered:" + this.centered);
        if (this.centered) {
            ((GuiState)this.getState(GuiState.class)).center((Panel)this.window);
        } else {
            float height = ((GuiState)this.getState(GuiState.class)).getGuiSize().y;
            this.window.setLocalTranslation(20.0f, height - 20.0f, 0.0f);
        }
    }
}

