/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.net;

import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.CreatedBy;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.es.Name;
import com.simsilica.fsm.StateMachine;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.HAlignment;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.ListBox;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.ValueRenderer;
import com.simsilica.lemur.component.BorderLayout;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.lemur.value.DefaultValueRenderer;
import mythruna.client.GameSessionState;
import mythruna.client.GuiState;
import mythruna.client.net.CharacterEditor;
import mythruna.client.net.ConnectionState;
import mythruna.client.sound.SoundState;
import mythruna.net.AccountSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LobbyState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(LobbyState.class);
    private boolean singlePlayer;
    private StateMachine<String, String> fsm;
    private Container window;
    private ListBox<Entity> characterList;
    private Label worldName;
    private EntityData ed;
    private EntityId player;
    private CharacterContainer charContainer;
    private VersionedList<Entity> characters = new VersionedList();
    private CharacterEditor charEditor;

    public LobbyState(boolean singlePlayer, StateMachine<String, String> fsm) {
        this.fsm = fsm;
        this.singlePlayer = singlePlayer;
        this.setEnabled(false);
    }

    protected void play() {
        ((SoundState)this.getState(SoundState.class)).stopAll(5.0f);
        log.info("play");
        Entity character = (Entity)this.characterList.getSelectedItem();
        if (character == null) {
            log.info("no character selected");
            return;
        }
        this.fsm.trigger((Object)"play", (Object)character.getId());
        try {
            AccountSession account = ((ConnectionState)this.getState(ConnectionState.class)).getService(AccountSession.class);
            account.enterWorld(character.getId());
        }
        catch (Exception e) {
            log.error("Error entering world", (Throwable)e);
            this.fsm.trigger((Object)"failure", (Object)e);
            return;
        }
        this.getStateManager().attach((AppState)new GameSessionState(this.singlePlayer));
    }

    protected void exit() {
        log.info("exit");
        this.fsm.trigger((Object)"exit");
    }

    protected void createCharacter() {
        log.info("createCharacter()");
        this.charEditor.editCharacter(null, this::doCreateCharacter);
    }

    protected void doCreateCharacter() {
        log.info("doCreateCharacter()");
        AccountSession account = ((ConnectionState)this.getState(ConnectionState.class)).getService(AccountSession.class);
        account.createCharacter(this.charEditor.getName(), new EntityComponent[0]);
    }

    public void setPlayer(String userId) {
        this.ed = ((ConnectionState)this.getState(ConnectionState.class)).getEntityData();
        ComponentFilter filter = Filters.fieldEquals(Name.class, (String)"name", (Object)userId);
        this.setPlayer(this.ed.findEntity(filter, new Class[]{Name.class}));
        if (this.player == null) {
            throw new IllegalArgumentException("Player not found:" + userId);
        }
    }

    public void setPlayer(EntityId player) {
        this.ed = ((ConnectionState)this.getState(ConnectionState.class)).getEntityData();
        this.player = player;
        this.updateInfo();
    }

    protected void updateInfo() {
        AccountSession account = ((ConnectionState)this.getState(ConnectionState.class, true)).getService(AccountSession.class);
        EntityId worldEntity = account.getWorldEntity();
        Name name = (Name)this.ed.getComponent(worldEntity, Name.class);
        this.worldName.setText("World: " + name.getName());
    }

    protected void initialize(Application app) {
        this.window = new Container((GuiLayout)new BorderLayout(), new ElementId("window"));
        Container charMgr = (Container)this.window.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.Last, FillMode.Even)), new Object[]{BorderLayout.Position.West});
        charMgr.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "createCharacter")), new Object[0]);
        this.characterList = (ListBox)charMgr.addChild((Node)new ListBox(this.characters), new Object[0]);
        this.characterList.setVisibleItems(10);
        this.characterList.setCellRenderer((ValueRenderer)new CharacterRenderer());
        charMgr.addChild((Node)new Label(""), new Object[0]);
        this.worldName = (Label)this.window.addChild((Node)new Label("World Name", new ElementId("window.title")), new Object[]{BorderLayout.Position.North});
        this.worldName.setTextHAlignment(HAlignment.Center);
        Container buttons = (Container)this.window.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y)), new Object[]{BorderLayout.Position.South});
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "play")), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "exit")), new Object[0]);
        Vector2f size = ((GuiState)this.getState(GuiState.class)).getGuiSize();
        Vector3f pref = this.window.getPreferredSize().clone();
        pref.x = Math.max(size.x * 0.9f, pref.x);
        pref.y = Math.max(size.y * 0.9f, pref.y);
        this.window.setPreferredSize(pref);
        this.charEditor = new CharacterEditor();
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        ((GuiState)this.getState(GuiState.class)).center((Panel)this.window);
        GuiGlobals.getInstance().getPopupState().showModalPopup((Spatial)this.window);
        this.charContainer = new CharacterContainer(this.ed, this.player);
        this.charContainer.start();
    }

    public void update(float tpf) {
        this.charContainer.update();
    }

    protected void onDisable() {
        this.window.removeFromParent();
        this.charContainer.stop();
    }

    private class CharacterRenderer
    extends DefaultValueRenderer<Entity> {
        private CharacterRenderer() {
        }

        protected String valueToString(Entity value) {
            return ((Name)value.get(Name.class)).getName();
        }

        public Panel getView(Entity value, boolean selected, Panel existing) {
            Panel result = super.getView((Object)value, selected, existing);
            return result;
        }
    }

    private class CharacterContainer
    extends EntityContainer<Entity> {
        public CharacterContainer(EntityData ed, EntityId player) {
            super(ed, Filters.fieldEquals(CreatedBy.class, (String)"creatorId", (Object)player), new Class[]{CreatedBy.class, Name.class});
        }

        protected Entity addObject(Entity e) {
            LobbyState.this.characters.add((Object)e);
            return e;
        }

        protected void updateObject(Entity object, Entity e) {
        }

        protected void removeObject(Entity object, Entity e) {
            LobbyState.this.characters.remove((Object)e);
        }
    }
}

