/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.event;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.BaseAppState;
import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingSphere;
import com.jme3.bounding.BoundingVolume;
import com.jme3.input.event.InputEvent;
import com.jme3.input.event.MouseButtonEvent;
import com.jme3.input.event.MouseMotionEvent;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Quad;
import com.simsilica.lemur.Command;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.core.GuiControl;
import com.simsilica.lemur.core.GuiMaterial;
import com.simsilica.lemur.event.MouseEventControl;
import com.simsilica.lemur.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopupState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(PopupState.class);
    private Node guiNode;
    private ColorRGBA defaultBackgroundColor = new ColorRGBA(0.0f, 0.0f, 0.0f, 0.0f);
    private List<PopupEntry> stack = new ArrayList<PopupEntry>();
    private PopupEntry current;

    public PopupState() {
    }

    public PopupState(Node guiNode) {
        this.guiNode = guiNode;
    }

    public boolean hasActivePopups() {
        return this.isEnabled() && !this.stack.isEmpty();
    }

    public void showPopup(Spatial popup) {
        this.showPopup(popup, ClickMode.Close, null, null);
    }

    public void showPopup(Spatial popup, Command<? super PopupState> closeCommand) {
        this.showPopup(popup, ClickMode.Close, closeCommand, null);
    }

    public void showModalPopup(Spatial popup) {
        this.showPopup(popup, ClickMode.Consume, null, null);
    }

    public void showModalPopup(Spatial popup, Command<? super PopupState> closeCommand) {
        this.showPopup(popup, ClickMode.Consume, closeCommand, null);
    }

    public void showModalPopup(Spatial popup, ColorRGBA backgroundColor) {
        this.showPopup(popup, ClickMode.Consume, null, backgroundColor);
    }

    public void showModalPopup(Spatial popup, Command<? super PopupState> closeCommand, ColorRGBA backgroundColor) {
        this.showPopup(popup, ClickMode.Consume, closeCommand, backgroundColor);
    }

    public void showPopup(Spatial popup, ClickMode clickMode, Command<? super PopupState> closeCommand, ColorRGBA backgroundColor) {
        PopupEntry entry = new PopupEntry(popup, clickMode, closeCommand, backgroundColor);
        this.stack.add(entry);
        this.current = entry;
        this.current.show();
    }

    public boolean isPopup(Spatial s) {
        return this.getEntry(s) != null;
    }

    public void closePopup(Spatial popup) {
        PopupEntry entry = this.getEntry(popup);
        if (entry == null) {
            throw new IllegalArgumentException("Popup entry not found for:" + popup);
        }
        this.close(entry);
    }

    protected void close(PopupEntry entry) {
        if (!this.stack.remove(entry)) {
            return;
        }
        entry.release();
        this.current = !this.stack.isEmpty() ? this.stack.get(this.stack.size() - 1) : null;
    }

    protected PopupEntry getEntry(Spatial popup) {
        for (PopupEntry entry : this.stack) {
            if (entry.popup != popup) continue;
            return entry;
        }
        return null;
    }

    protected float getMaxGuiZ() {
        BoundingVolume bv = this.getGuiNode().getWorldBound();
        return this.getMaxZ(bv);
    }

    protected float getMaxZ(BoundingVolume bv) {
        if (bv instanceof BoundingBox) {
            BoundingBox bb = (BoundingBox)bv;
            return bb.getCenter().z + bb.getZExtent();
        }
        if (bv instanceof BoundingSphere) {
            BoundingSphere bs = (BoundingSphere)bv;
            return bs.getCenter().z + bs.getRadius();
        }
        if (bv == null) {
            return 0.0f;
        }
        Vector3f offset = bv.getCenter().add(0.0f, 0.0f, 1000.0f);
        return offset.z - bv.distanceTo(offset);
    }

    protected float getMinZ(BoundingVolume bv) {
        if (bv instanceof BoundingBox) {
            BoundingBox bb = (BoundingBox)bv;
            return bb.getCenter().z - bb.getZExtent();
        }
        if (bv instanceof BoundingSphere) {
            BoundingSphere bs = (BoundingSphere)bv;
            return bs.getCenter().z - bs.getRadius();
        }
        Vector3f offset = bv.getCenter().add(0.0f, 0.0f, -1000.0f);
        return offset.z + bv.distanceTo(offset);
    }

    protected GuiMaterial createBlockerMaterial(ColorRGBA color) {
        GuiMaterial result = GuiGlobals.getInstance().createMaterial(color, false);
        Material mat = result.getMaterial();
        mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        return result;
    }

    protected Geometry createBlocker(float z, ColorRGBA backgroundColor) {
        Camera cam = this.getApplication().getCamera();
        float width = (float)cam.getWidth() / this.guiNode.getLocalScale().x;
        float height = (float)cam.getHeight() / this.guiNode.getLocalScale().y;
        Quad quad = new Quad(width, height);
        Geometry result = new Geometry("blocker", (Mesh)quad);
        GuiMaterial guiMat = this.createBlockerMaterial(backgroundColor);
        result.setMaterial(guiMat.getMaterial());
        result.setLocalTranslation(0.0f, 0.0f, z);
        return result;
    }

    public Vector2f getGuiSize() {
        Camera cam = this.getApplication().getCamera();
        float width = (float)cam.getWidth() / this.getGuiNode().getLocalScale().x;
        float height = (float)cam.getHeight() / this.getGuiNode().getLocalScale().y;
        return new Vector2f(width, height);
    }

    public void centerInGui(Spatial s) {
        GuiControl control = (GuiControl)s.getControl(GuiControl.class);
        if (control == null) {
            throw new UnsupportedOperationException("Only spatials with GuiControls are supported");
        }
        Vector2f guiSize = this.getGuiSize();
        Vector3f size = control.getSize();
        if (size.length() == 0.0f) {
            size = control.getPreferredSize();
        }
        size = size.mult(s.getLocalScale());
        Vector3f pos = s.getWorldTranslation();
        Vector3f target = new Vector3f();
        target.x = guiSize.x * 0.5f - size.x * 0.5f;
        target.y = guiSize.y * 0.5f + size.y * 0.5f;
        target.z = pos.z;
        s.move(target.subtract(pos));
    }

    public boolean clampToGui(Spatial s) {
        float y;
        float x;
        GuiControl control = (GuiControl)s.getControl(GuiControl.class);
        if (control == null) {
            throw new UnsupportedOperationException("Only spatials with GuiControls are supported");
        }
        Vector2f guiSize = this.getGuiSize();
        Vector3f size = control.getSize();
        if (size.length() == 0.0f) {
            size = control.getPreferredSize();
        }
        Vector3f pos = s.getWorldTranslation();
        Vector3f delta = new Vector3f();
        if (size.x > guiSize.x) {
            x = guiSize.x * 0.5f - size.x * 0.5f;
            delta.x = x - pos.x;
        } else if (pos.x < 0.0f) {
            delta.x = -pos.x;
        } else if (pos.x + size.x > guiSize.x) {
            x = guiSize.x - size.x;
            delta.x = x - pos.x;
        }
        if (size.y > guiSize.y) {
            y = guiSize.y * 0.5f - size.y * 0.5f;
            delta.y = y - pos.y;
        } else if (pos.y > guiSize.y) {
            delta.y = guiSize.y - pos.y;
        } else if (pos.y - size.y < 0.0f) {
            y = size.y;
            delta.y = y - pos.y;
        }
        s.move(delta);
        return delta.length() != 0.0f;
    }

    public void setGuiNode(Node guiNode) {
        this.guiNode = guiNode;
    }

    public Node getGuiNode() {
        if (this.guiNode != null) {
            return this.guiNode;
        }
        Application app = this.getApplication();
        if (app instanceof SimpleApplication) {
            this.guiNode = ((SimpleApplication)app).getGuiNode();
        }
        return this.guiNode;
    }

    protected void initialize(Application app) {
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
    }

    public void update(float tpf) {
        if (this.current != null && !this.current.isVisible()) {
            this.close(this.current);
        }
    }

    protected void onDisable() {
    }

    private class BlockerListener
    implements MouseListener {
        private PopupEntry entry;

        public BlockerListener(PopupEntry entry) {
            this.entry = entry;
        }

        public boolean isPassive() {
            switch (this.entry.clickMode) {
                case ConsumeAndClose: 
                case Consume: {
                    return false;
                }
            }
            return true;
        }

        protected void handle(InputEvent event, boolean closeableEvent) {
            switch (this.entry.clickMode) {
                case Close: {
                    if (!closeableEvent) break;
                    PopupState.this.close(this.entry);
                    break;
                }
                case ConsumeAndClose: {
                    if (closeableEvent) {
                        PopupState.this.close(this.entry);
                    }
                    event.setConsumed();
                    break;
                }
                case Consume: {
                    event.setConsumed();
                }
            }
        }

        @Override
        public void mouseButtonEvent(MouseButtonEvent event, Spatial target, Spatial capture) {
            this.handle((InputEvent)event, true);
        }

        @Override
        public void mouseEntered(MouseMotionEvent event, Spatial target, Spatial capture) {
            this.handle((InputEvent)event, false);
        }

        @Override
        public void mouseExited(MouseMotionEvent event, Spatial target, Spatial capture) {
            this.handle((InputEvent)event, false);
        }

        @Override
        public void mouseMoved(MouseMotionEvent event, Spatial target, Spatial capture) {
            this.handle((InputEvent)event, false);
        }
    }

    private class PopupEntry {
        private Spatial popup;
        private ClickMode clickMode;
        private Command<? super PopupState> closeCommand;
        private ColorRGBA backgroundColor;
        private float zBase;
        private Geometry blocker;
        private GuiMaterial blockerMaterial;
        private BlockerListener blockerListener;

        public PopupEntry(Spatial popup, ClickMode clickMode, Command<? super PopupState> closeCommand, ColorRGBA backgroundColor) {
            this.popup = popup;
            this.clickMode = clickMode;
            this.closeCommand = closeCommand;
            this.backgroundColor = backgroundColor != null ? backgroundColor : PopupState.this.defaultBackgroundColor;
            this.zBase = PopupState.this.getMaxGuiZ() + 1.0f;
            this.blocker = PopupState.this.createBlocker(this.zBase, this.backgroundColor);
            MouseEventControl.addListenersToSpatial((Spatial)this.blocker, new BlockerListener(this));
        }

        public boolean isVisible() {
            return this.popup.getParent() != null;
        }

        public void show() {
            float zOffset = PopupState.this.getMinZ(this.popup.getWorldBound());
            PopupState.this.getGuiNode().attachChild((Spatial)this.blocker);
            PopupState.this.getGuiNode().attachChild(this.popup);
            float zPopup = this.zBase + 1.0f;
            if (zOffset < 0.0f) {
                zPopup -= zOffset;
            }
            this.popup.move(0.0f, 0.0f, zPopup);
            if (this.popup instanceof Panel) {
                ((Panel)this.popup).runEffect("open");
            }
            GuiGlobals.getInstance().requestCursorEnabled(this);
            GuiGlobals.getInstance().requestFocus(this.popup);
        }

        public void release() {
            if (this.popup instanceof Panel && ((Panel)this.popup).hasEffect("close")) {
                ((Panel)this.popup).runEffect("close");
            } else {
                this.popup.removeFromParent();
            }
            this.blocker.removeFromParent();
            if (this.closeCommand != null) {
                this.closeCommand.execute(PopupState.this);
            }
            GuiGlobals.getInstance().releaseCursorEnabled(this);
            GuiGlobals.getInstance().releaseFocus(this.popup);
        }
    }

    public static enum ClickMode {
        Consume,
        Close,
        ConsumeAndClose;

    }
}

