/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mod;

import com.simsilica.mod.ModInfo;
import com.simsilica.mod.ModManager;
import com.simsilica.mod.ModPack;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileModPack
extends ModPack {
    static Logger log = LoggerFactory.getLogger(FileModPack.class);
    private File root;
    private File infoFile;
    private List<FileRef> files = new ArrayList<FileRef>();

    public FileModPack(File infoFile, ModInfo info) {
        super(infoFile.getParentFile().toURI(), info);
        this.root = infoFile.getParentFile();
        this.infoFile = infoFile;
    }

    public boolean hasChanged() {
        for (FileRef ref : this.files) {
            if (!ref.hasChanged()) continue;
            return true;
        }
        return false;
    }

    public void reload() {
        this.terminate();
        this.initialize(this.getModManager());
    }

    @Override
    public void initialize(ModManager manager) {
        super.initialize(manager);
        this.files.add(new FileRef(this.infoFile));
        for (String s : this.getInfo().getInitScripts()) {
            this.files.add(new FileRef(new File(this.root, s)));
        }
        for (String s : this.getInfo().getTerminateScripts()) {
            this.files.add(new FileRef(new File(this.root, s)));
        }
    }

    @Override
    public void terminate() {
        super.terminate();
        this.files.clear();
    }

    private class FileRef {
        private File file;
        private long lastModified;

        public FileRef(File file) {
            this.file = file;
            this.lastModified = file.lastModified();
            log.info("Tracking:" + file);
        }

        public boolean hasChanged() {
            return this.lastModified != this.file.lastModified();
        }
    }
}

