/*
 * Decompiled with CFR 0.152.
 */
package mythruna.es;

import com.google.common.base.MoreObjects;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityId;
import com.simsilica.es.PersistentComponent;
import com.simsilica.es.StringType;
import com.simsilica.mathd.Vec3i;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlueprintInfo
implements EntityComponent,
PersistentComponent {
    static Logger log = LoggerFactory.getLogger(BlueprintInfo.class);
    private EntityId parent;
    @StringType(maxLength=40)
    private String name;
    private Vec3i offset;
    private long lastModified;

    public BlueprintInfo() {
    }

    public BlueprintInfo(EntityId parent, String name, Vec3i offset) {
        this(parent, name, offset, System.currentTimeMillis());
    }

    public BlueprintInfo(EntityId parent, String name, Vec3i offset, long lastModified) {
        this.parent = parent;
        this.name = name;
        this.offset = offset.clone();
        this.lastModified = lastModified;
    }

    public BlueprintInfo changeOffset(Vec3i offset) {
        return new BlueprintInfo(this.parent, this.name, offset);
    }

    public BlueprintInfo changeName(String name) {
        return new BlueprintInfo(this.parent, name, this.offset);
    }

    public BlueprintInfo changeParent(EntityId parent) {
        return new BlueprintInfo(parent, this.name, this.offset);
    }

    public BlueprintInfo changeLastModified() {
        return new BlueprintInfo(this.parent, this.name, this.offset);
    }

    public EntityId getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public Vec3i getOffset() {
        return this.offset;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        BlueprintInfo other = (BlueprintInfo)o;
        if (!Objects.equals(this.parent, other.parent)) {
            return false;
        }
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.offset, other.offset)) {
            return false;
        }
        return other.lastModified == this.lastModified;
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.name, this.offset, this.lastModified);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("parent", (Object)this.parent).add("name", (Object)this.name).add("offset", (Object)this.offset).add("lastModified", this.lastModified).toString();
    }
}

