/*
 * Copyright (c) 2022, Simsilica, LLC
 * All rights reserved.
 */

if( singlePlayer ) {
    log.info("Single player game, skipping account manager setup");
    return;
}

import com.simsilica.account.*;
import com.simsilica.account.base.*;
import com.simsilica.account.base.json.*;

// Create a standard account manager and add it to 
// the available game systems.

// By default, we will put the account manager in a central location
// for all of the worlds so that accounts are shared across different
// worlds.
// This is a bit of a hack until we can inject global configs
// better.
// FIXME - inject the accounts root externally
def File worldRoot = worldManager.info.directory;
def File root = new File(worldRoot, "../../accounts").canonicalFile;

log.info("Accounts root:" + root);
if( !root.exists() ) {
    if( !root.mkdirs() ) {
        log.warn("Unable to create directory:" + root);
    }
}

// Varargs parameter for what classes we allow in the 
// users' custom properties.
def storage = new JsonAccountStorage(root, Vec3d.class);
accountManager = new DefaultAccountManager(storage);

// Make it available to other game systems
gameSystems.register(AccountManager.class, accountManager);

// The guid generator for converting local userIDs into global
// user IDs.  For lack of anything better, we will hard code
// this... game host setups will have to reset this if desired.
// Brings to mind things like "serverID", etc.
accountManager.guidGenerator = { "localhost@" + it };

// Setup the authenticators we will support.
accountManager.addAuthenticator(HashAuthenticator.SHA512);

// Add a "save" method to the account class
Account.metaClass {
    save() {
        accountManager.saveAccount(delegate); 
    }
}


// Some standard things we will record on the account
on( accountCreated ) { event ->
    event.account.setProperty("created", System.currentTimeMillis());
    event.account.save();    
}

//on( accountLoggingOn ) { event ->
//    // Here is our chance to check for additional properties
//    // before login is complete... we can abort loging if the
//    // player is banned or for other reasons.
//    if( event.account.getProperty("banned") ) {
//        throw new RuntimeException("Login refused. Contact the server admin for details.");
//    }
//}

on( accountLoggedOn ) { event ->
    // Here is our chance to check for additional properties
    // before login is complete... we can kick the player if we
    // don't like them.
    if( event.account.getProperty("banned", Boolean.class) ) {
         event.connection.close("Login refused. Contact the server admin for details.");
    }

    event.account.setProperty("lastLoginTime", System.currentTimeMillis());    
    event.account.save();    
}

on( accountLoggedOff ) { event ->
    if( event.account ) {
        event.account.setProperty("lastLogoffTime", System.currentTimeMillis());    
        event.account.save();
    }    
}

