
import com.simsilica.bpos.LargeGridCell;

// This will eventually be some other kind of object for the
// permissions chain
defaultWorldPermissions = new ClaimPermissions(null, 
                                    ClaimPermissions.BLOCK_ADD, 
                                    ClaimPermissions.BLOCK_REMOVE, 
                                    ClaimPermissions.OBJ_ADD, 
                                    ClaimPermissions.OBJ_REMOVE, 
                                    ClaimPermissions.OBJ_MOVE, 
                                    ClaimPermissions.OBJ_CHANGE,
                                    ClaimPermissions.PROP_ADD, 
                                    ClaimPermissions.PROP_REMOVE, 
                                    ClaimPermissions.PROP_MOVE, 
                                    ClaimPermissions.PROP_CHANGE); 
 

/**
 *  Find any claims that might by in the vicinity of the
 *  specified location.
 */
findClaims = { pos ->

    // Find all of the claims in this and the immediately 
    // surrounding tiles.  This should cover a 3x1024^2 area
    // for looking for center markers.  Hopefully that's big
    // enough because there really could be a LOT of claims
    // in that area.
    int radius = 1;
    int size = radius * 2 + 1;
    ComponentFilter[] filters = new ComponentFilter[size * size];
    
    def largeCenter = GameConstants.LARGE_OBJECT_GRID.worldToCell(pos as Vec3d); 
    int xOffset = largeCenter.x - radius;
    int zOffset = largeCenter.z - radius;
    int index = 0;
    for( int x = 0; x < size; x++ ) {
        for( int z = 0; z < size; z++ ) {
            long id = GameConstants.LARGE_OBJECT_GRID.cellToId(xOffset + x, 0, zOffset + z);
            ComponentFilter filter = Filters.fieldEquals(LargeGridCell.class, "cellId", id);
            filters[index++] = filter;
        }
    }

    return findEntities(Filters.or(LargeGridCell.class, filters), LargeGridCell, ClaimArea);
    //return findEntities(null, ClaimArea);
}

getIntersections = { area ->
    def center = (area.min + area.max) / 2;
    def results = [] as Set;
    findClaims(center).each { it ->
        if( area.intersects(it[ClaimArea]) ) {
            results.add(it);
        }
    }
    return results;
}

getClaim = { Activator activator, loc ->
 
    if( loc instanceof Vec3d ) {
        loc = loc.floor();
    }
    
    // Caching is tricky because we'd need to watch for claim area updates
    // and flush the cache.  We should do it... but it will wait until things
    // are working.  And it will be a proper area cache, not an activator-based cache
    //def lastLoc = activator.getProperty("lastClaimLoc")?.floor();
    ////def loc = activator.getPos()?.floor();
    //
    //if( loc == lastLoc ) {
    //    return activator.getProperty("claim");
    //}

    // Else we need to find the claim
    for( EntityId claim : findClaims(loc) ) {
        if( log.isDebugEnabled() ) {
            log.debug("Checking:" + claim);
        }
        if( claim[ClaimArea].contains(loc) ) {
            return claim;
        } 
    }

    return null;
}

getPerms = { Activator activator, loc ->
    
    // If we are admin then we always have permission
    if( activator.getProperty("account")?.getProperty("permissions", List.class)?.contains("admin") ) {;
        return defaultWorldPermissions;
    }

    def claim = getClaim(activator, loc);
    if( log.isDebugEnabled() ) {
        log.debug("claim:" + claim);
    }    
    if( claim == null ) {
        return defaultWorldPermissions;
    }
 
    if( log.isDebugEnabled() ) {
        log.debug("owner:" + claim[OwnedBy].owner + " us:" + activator);
    }        
    // Else is it ours?
    if( activator.isSameEntity(claim[OwnedBy].owner) ) {
        return ClaimPermissions.createOwnerPermissions(activator.id);
    }
 
    if( log.isDebugEnabled() ) {
        log.debug("no access");
    }
    // For the moment... we really want to look for entities on our
    // person that give us permission
    return ClaimPermissions.createNoAccess(claim); 
}

findProperty = { EntityId owner ->
    def filter = Filters.fieldEquals(OwnedBy, "owner", owner);
    return findEntities(filter, OwnedBy, ClaimType); 
}

grantProperty = { EntityId target, String name, ClaimType type ->

    def claim = createEntity(
            new Name(name),
            ObjectName.create("Claim Area", entityData),
            ObjectTypeInfo.create("Claim", entityData),
            new ContainedIn(target, target, 0, 0),
            type,
            new OwnedBy(target)
        );

    // It doesn't get position, area, etc. until placed
    return claim;
}


// The default property grants
on( playerEntityCreated ) { event ->
}

on( playerEntityJoined ) { event ->
    // Since we already have players without strongholds we'll
    // check for missing strongholds on join instead of relying on created
    
    def stronghold = findProperty(event.player).find { it[ClaimType]?.type == ClaimType.TYPE_STRONGHOLD };
    
    log.info("Found existing stronghold:" + stronghold);
    
    if( stronghold == null ) {
        def name = event.player.name;
        log.info("Creating stronghold for player:" + event.player + " name:" + name);
        grantProperty(event.player, "" + name + "'s Stronghold", 
                      ClaimType.createStandard(ClaimType.TYPE_STRONGHOLD)); 
    } else {
        // We could uprgade it if we forgot something
    }
}

