/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.ext.mblock;

import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.db.CellArrayId;
import com.simsilica.mblock.io.BlocksFileFormat;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellArrayFunctions {
    static Logger log = LoggerFactory.getLogger(CellArrayFunctions.class);

    public static Function<String, CellArray> blocksResource() {
        return new BlocksFunction(".blocks");
    }

    public static Function<String, CellArray> cellArrayStorage(Function<CellArrayId, CellArray> storage) {
        return new CellArrayStorageFunction(".ca", storage);
    }

    public static Function<String, CellArray> chain(Function ... delegates) {
        return new CellArrayStorageFunctionChain(delegates);
    }

    public static class BlocksFunction
    implements Function<String, CellArray> {
        private String extension;

        public BlocksFunction(String extension) {
            this.extension = extension;
        }

        @Override
        public CellArray apply(String name) {
            if (!name.endsWith(this.extension)) {
                return null;
            }
            try {
                log.info("Loading .blocks:" + name);
                return BlocksFileFormat.loadCellArray((String)name);
            }
            catch (Exception e) {
                throw new RuntimeException("Error loading resource:" + name, e);
            }
        }
    }

    public static class CellArrayStorageFunction
    implements Function<String, CellArray> {
        private String extension;
        private Function<CellArrayId, CellArray> storage;

        public CellArrayStorageFunction(String extension, Function<CellArrayId, CellArray> storage) {
            this.extension = extension;
            this.storage = storage;
        }

        protected CellArrayId nameToId(String name) {
            int split = name.lastIndexOf("_");
            if (split >= 0) {
                name = name.substring(split + 1);
            }
            return CellArrayId.fromFileName((String)name);
        }

        @Override
        public CellArray apply(String name) {
            if (!name.endsWith(this.extension)) {
                return null;
            }
            CellArrayId id = this.nameToId(name);
            if (id == null) {
                return null;
            }
            log.info("Loading from storage, cell array:" + id);
            return this.storage.apply(id);
        }
    }

    public static class CellArrayStorageFunctionChain
    implements Function<String, CellArray> {
        private Function[] delegates;

        public CellArrayStorageFunctionChain(Function ... delegates) {
            this.delegates = delegates;
        }

        @Override
        public CellArray apply(String name) {
            for (Function f : this.delegates) {
                Object result = f.apply(name);
                if (result == null) continue;
                return (CellArray)result;
            }
            return null;
        }
    }
}

