/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.river;

import com.simsilica.ethereal.io.BitInputStream;
import com.simsilica.ethereal.io.BitOutputStream;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.io.ObjectProtocol;
import java.io.IOException;
import mythruna.world.river.RiverSection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RiverSectionProtocol
implements ObjectProtocol<RiverSection> {
    static Logger log = LoggerFactory.getLogger(RiverSectionProtocol.class);
    public static final int X_BITS = 32;
    public static final int Y_BITS = 10;
    public static final int Z_BITS = 32;
    public static final int DEPTH_BITS = 6;
    public static final int INFLUENCE_BITS = 7;
    public static final int RADIUS_BITS = 6;
    private int version = 0;

    public int getProtocolVersion() {
        return this.version;
    }

    public void write(RiverSection data, BitOutputStream out) throws IOException {
        out.writeBits(this.version, 8);
        Vec3i start = data.getStart();
        Vec3i end = data.getEnd();
        out.writeBits(start.x, 32);
        out.writeBits(start.y, 10);
        out.writeBits(start.z, 32);
        out.writeBits(end.x, 32);
        out.writeBits(end.y, 10);
        out.writeBits(end.z, 32);
        out.writeBits(data.getDepth(), 6);
        out.writeBits(data.getInfluence(), 7);
        out.writeBits(data.getRadius(), 6);
    }

    public RiverSection read(BitInputStream in) throws IOException {
        int version = in.readBits(8);
        int x = in.readBits(32);
        int y = in.readBits(10);
        int z = in.readBits(32);
        Vec3i start = new Vec3i(x, y, z);
        x = in.readBits(32);
        y = in.readBits(10);
        z = in.readBits(32);
        Vec3i end = new Vec3i(x, y, z);
        int depth = in.readBits(6);
        int influence = in.readBits(7);
        int radius = in.readBits(6);
        return new RiverSection(start, end, depth, influence, radius);
    }
}

