/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.Direction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellArrayNeighborhood
implements CellData {
    static Logger log = LoggerFactory.getLogger(CellArrayNeighborhood.class);
    private int radius;
    private int size;
    private int xArraySize;
    private int yArraySize;
    private int zArraySize;
    private CellArray center;
    private CellArray[][][] neighborhood;

    public CellArrayNeighborhood(CellArray center, int radius) {
        this.radius = radius;
        this.size = 1 + radius * 2;
        this.neighborhood = new CellArray[this.size][this.size][this.size];
        this.center = center;
        this.neighborhood[radius][radius][radius] = center;
        this.xArraySize = center.getSizeX();
        this.yArraySize = center.getSizeY();
        this.zArraySize = center.getSizeZ();
    }

    public void setCellArray(int xOffset, int yOffset, int zOffset, CellArray array) {
        this.neighborhood[this.radius + xOffset][this.radius + yOffset][this.radius + zOffset] = array;
    }

    public CellArray getCellArray(int xOffset, int yOffset, int zOffset) {
        return this.neighborhood[this.radius + xOffset][this.radius + yOffset][this.radius + zOffset];
    }

    @Override
    public int getCell(int x, int y, int z) {
        return this.getCell(x, y, z, 0);
    }

    @Override
    public int getCell(int x, int y, int z, int defaultValue) {
        int xArray = this.radius;
        int yArray = this.radius;
        int zArray = this.radius;
        if (x < 0) {
            xArray += (int)Math.floor(x / this.xArraySize);
            x = this.xArraySize + x % this.xArraySize;
        } else if (x >= this.xArraySize) {
            xArray += (int)Math.floor(x / this.xArraySize);
            x %= this.xArraySize;
        }
        if (xArray < 0 || xArray >= this.size) {
            return defaultValue;
        }
        if (y < 0) {
            yArray += (int)Math.floor(y / this.yArraySize);
            y = this.yArraySize + y % this.yArraySize;
        } else if (y >= this.yArraySize) {
            yArray += (int)Math.floor(y / this.yArraySize);
            y %= this.yArraySize;
        }
        if (yArray < 0 || yArray >= this.size) {
            return defaultValue;
        }
        if (z < 0) {
            zArray += (int)Math.floor(z / this.zArraySize);
            z = this.zArraySize + z % this.zArraySize;
        } else if (z >= this.zArraySize) {
            zArray += (int)Math.floor(z / this.zArraySize);
            z %= this.zArraySize;
        }
        if (zArray < 0 || zArray >= this.size) {
            return defaultValue;
        }
        CellArray array = this.neighborhood[xArray][yArray][zArray];
        if (array == null) {
            return defaultValue;
        }
        return array.getCell(x, y, z);
    }

    @Override
    public int getCell(int x, int y, int z, Direction dir, int defaultValue) {
        Vec3i v = dir.getVec3i();
        return this.getCell(x + v.x, y + v.y, z + v.z, defaultValue);
    }

    @Override
    public void setCell(int x, int y, int z, int type) {
        int xArray = this.radius;
        int yArray = this.radius;
        int zArray = this.radius;
        if (x < 0) {
            xArray += (int)Math.floor(x / this.xArraySize);
            x = this.xArraySize + x % this.xArraySize;
        } else if (x >= this.xArraySize) {
            xArray += (int)Math.floor(x / this.xArraySize);
            x %= this.xArraySize;
        }
        if (xArray < 0 || xArray >= this.size) {
            throw new IllegalArgumentException("x out of bounds");
        }
        if (y < 0) {
            yArray += (int)Math.floor(y / this.yArraySize);
            y = this.yArraySize + y % this.yArraySize;
        } else if (y >= this.yArraySize) {
            yArray += (int)Math.floor(y / this.yArraySize);
            y %= this.yArraySize;
        }
        if (yArray < 0 || yArray >= this.size) {
            throw new IllegalArgumentException("y out of bounds");
        }
        if (z < 0) {
            zArray += (int)Math.floor(z / this.zArraySize);
            z = this.zArraySize + z % this.zArraySize;
        } else if (z >= this.zArraySize) {
            zArray += (int)Math.floor(z / this.zArraySize);
            z %= this.zArraySize;
        }
        if (zArray < 0 || zArray >= this.size) {
            throw new IllegalArgumentException("z out of bounds");
        }
        CellArray array = this.neighborhood[xArray][yArray][zArray];
        if (array == null) {
            throw new IllegalArgumentException("x,y,z not loaded");
        }
        array.setCell(x, y, z, type);
    }
}

