/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view;

import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.es.EntityId;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Selector;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.input.FunctionId;
import com.simsilica.lemur.input.InputMapper;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.mblock.BlockName;
import com.simsilica.mblock.BlockType;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.LightUtils;
import com.simsilica.mblock.MaskUtils;
import com.simsilica.mblock.geom.GeometryFactory;
import com.simsilica.mworld.BlockIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import mythruna.client.GameSessionState;
import mythruna.client.GuiState;
import mythruna.client.view.AvatarState;
import mythruna.net.GameSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockTypeSelectionState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(BlockTypeSelectionState.class);
    public static final FunctionId F_CHOOSE = new FunctionId("Activation", "Choose Type");
    private GameSession session;
    private Container window;
    private SetMultimap<String, String> baseShapes = MultimapBuilder.treeKeys().treeSetValues().build();
    private VersionedList<String> baseNames = new VersionedList();
    private VersionedList<String> shapeNames = new VersionedList();
    private Selector<String> base;
    private VersionedReference<String> baseRef;
    private Selector<String> shape;
    private VersionedReference<String> shapeRef;
    private List<Integer> rotations = new ArrayList<Integer>();
    private BlockName lastName = null;
    private int selectedType = -1;
    private int rotation = 0;
    private EntityId tool;
    private CellArray indicatorCells = new CellArray(1, 1, 1);
    private CellArray indicatorLights = new CellArray(1, 1, 1);
    private Node indicatorHolder;
    private Node indicator;

    public BlockTypeSelectionState() {
        this.setEnabled(false);
    }

    public void setTool(EntityId tool) {
        this.tool = tool;
    }

    public EntityId getTool() {
        return this.tool;
    }

    public int getSelectedType() {
        return this.selectedType;
    }

    public void open() {
        if (this.tool == null) {
            return;
        }
        this.setEnabled(true);
    }

    public void adjustRotation(int delta) {
        if (this.tool == null) {
            return;
        }
        log.info("adjustRotation(" + delta + ")");
        this.rotation += delta;
        if (this.rotation < 0) {
            this.rotation = !this.rotations.isEmpty() ? (this.rotation += this.rotations.size()) : 0;
        }
        this.rotation %= this.rotations.size();
        this.resetServerSelection();
        this.resetIndicator();
    }

    public void select() {
        this.resetServerSelection();
        this.resetIndicator();
        ((GameSessionState)this.getState(GameSessionState.class)).trigger("returnToGame");
    }

    public void selectUnderCursor() {
        if (this.tool == null) {
            return;
        }
        log.info("selectUnderCursor()");
        Iterator<BlockIterator.Intersection> it = ((AvatarState)this.getState(AvatarState.class)).pick(10);
        if (it.hasNext()) {
            int type;
            BlockIterator.Intersection hit = it.next();
            log.info("hit:" + hit);
            this.selectedType = type = hit.getType();
            this.resetSelected();
            this.resetRotations();
            this.rotation = 0;
            for (int i = 0; i < this.rotations.size(); ++i) {
                if (type != this.rotations.get(i)) continue;
                this.rotation = i;
                break;
            }
            this.resetServerSelection();
            this.resetIndicator();
        }
    }

    protected void resetRotations() {
        BlockType[] types = BlockTypeIndex.getTypes();
        String baseName = (String)this.base.getSelectedItem();
        String shapeName = (String)this.shape.getSelectedItem();
        if (this.lastName == null || !Objects.equals(this.lastName.getBase(), baseName) || !Objects.equals(this.lastName.getShape(), shapeName)) {
            this.rotations.clear();
            for (int i = 0; i < types.length; ++i) {
                BlockName name;
                BlockType type = types[i];
                if (type == null || !Objects.equals((name = type.getName()).getBase(), baseName) || !Objects.equals(name.getShape(), shapeName)) continue;
                this.rotations.add(i);
            }
            this.lastName = new BlockName(baseName, shapeName);
        }
    }

    protected void resetServerSelection() {
        this.resetRotations();
        this.selectedType = this.rotations.isEmpty() ? 0 : this.rotations.get(this.rotation % this.rotations.size());
        if (this.tool != null) {
            this.session.runAction(this.tool, "selectType", new Object[]{this.selectedType});
        }
    }

    public void cancel() {
        ((GameSessionState)this.getState(GameSessionState.class)).trigger("returnToGame");
    }

    protected void initialize(final Application app) {
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.map(F_CHOOSE, 46, new Object[0]);
        inputMapper.addDelegate(F_CHOOSE, (Object)this, "selectUnderCursor");
        this.session = ((GameSessionState)this.getState(GameSessionState.class, true)).getGameSession();
        if (this.selectedType == -1) {
            this.selectedType = BlockTypeIndex.findType((BlockName)new BlockName("dirt", "cube"));
        }
        this.indicator = new Node();
        ElementId baseId = new ElementId("block.popup");
        this.window = new Container(baseId);
        this.window.addChild((Node)new Label("Temporary Block Palette", baseId.child("window.title")), new Object[0]);
        Container selectors = (Container)this.window.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y)), new Object[0]);
        selectors.addChild((Node)new Label("Base:", baseId.child("label")), new Object[0]);
        this.base = (Selector)selectors.addChild((Node)new Selector(this.baseNames, baseId.child("selector")), new Object[0]);
        this.baseRef = this.base.createSelectedItemReference();
        selectors.addChild((Node)new Label("Shape:", baseId.child("label")), new Object[0]);
        this.shape = (Selector)selectors.addChild((Node)new Selector(this.shapeNames, baseId.child("selector")), new Object[0]);
        this.shapeRef = this.shape.createSelectedItemReference();
        selectors.addChild((Node)new Label(""), new Object[0]);
        selectors.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "select"), baseId.child("button")), new Object[0]);
        selectors.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "cancel"), baseId.child("button")), new Object[0]);
        for (BlockType type : BlockTypeIndex.getTypes()) {
            if (type == null) continue;
            BlockName name = type.getName();
            this.baseShapes.put((Object)name.getBase(), (Object)name.getShape());
        }
        this.baseNames.addAll((Collection)this.baseShapes.keySet());
        this.resetSelected();
        this.resetIndicator();
        this.resetServerSelection();
        Node gui = ((GuiState)this.getState(GuiState.class, true)).getGuiRoot();
        this.indicatorHolder = new Node("indicatorHolder"){

            public void updateLogicalState(float tpf) {
                super.updateLogicalState(tpf);
                Vector3f loc = app.getCamera().getLocation();
                Vector3f dir = app.getCamera().getDirection();
                Vector3f up = app.getCamera().getUp();
                Quaternion rot = app.getCamera().getRotation();
                this.setLocalTranslation(loc.add(dir.mult(0.5f)).subtractLocal(up.mult(0.265f)));
            }
        };
        this.indicatorHolder.setLocalTranslation((float)app.getCamera().getWidth() * 0.5f, 25.0f, 0.0f);
        ((SimpleApplication)this.getApplication()).getRootNode().attachChild((Spatial)this.indicatorHolder);
        this.indicatorHolder.setLocalScale(0.025f);
    }

    protected void resetSelected() {
        BlockType selected = BlockTypeIndex.get((int)this.selectedType);
        if (selected == null) {
            return;
        }
        BlockName name = selected.getName();
        this.base.setSelectedItem((Object)name.getBase());
        this.baseRef.update();
        this.resetShapes(name.getBase());
        this.shape.setSelectedItem((Object)name.getShape());
    }

    protected void cleanup(Application app) {
        this.indicator.removeFromParent();
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.removeDelegate(F_CHOOSE, (Object)this, "selectUnderCursor");
    }

    protected void onEnable() {
        this.getApplication().enqueue(() -> {
            Vector3f pref = this.window.getPreferredSize();
            this.window.setLocalTranslation(10.0f, pref.y + 10.0f, 0.0f);
            GuiGlobals.getInstance().getPopupState().showModalPopup((Spatial)this.window, new ColorRGBA(0.0f, 0.0f, 0.0f, 0.01f));
        });
    }

    protected void onDisable() {
        this.window.removeFromParent();
    }

    public void update(float tpf) {
        if (this.baseRef.update()) {
            this.resetShapes((String)this.baseRef.get());
        }
    }

    protected void resetShapes(String baseName) {
        this.shapeNames.clear();
        Set set = this.baseShapes.get((Object)baseName);
        if (set == null || set.isEmpty()) {
            return;
        }
        for (String s : set) {
            this.shapeNames.add((Object)s);
        }
    }

    protected void resetIndicator() {
        int val = MaskUtils.setSideMask((int)Math.max(0, this.selectedType), (int)63);
        this.indicatorCells.setCell(0, 0, 0, val);
        this.indicatorLights.setCell(0, 0, 0, LightUtils.DIRECT_SUN);
        GeometryFactory geomFactory = ((GameSessionState)this.getState(GameSessionState.class, true)).getGeometryFactory();
        Node blocks = geomFactory.generateBlocks(this.indicator, this.indicatorCells, (CellData)this.indicatorLights, false);
        blocks.setLocalTranslation(-0.5f, -0.5f, -0.5f);
    }
}

