/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.asset.AssetManager;
import com.jme3.post.Filter;
import com.jme3.post.FilterPostProcessor;
import com.jme3.post.SceneProcessor;
import com.jme3.post.filters.BloomFilter;
import com.jme3.system.AppSettings;
import com.simsilica.fx.shadow.DropShadowFilter;

public class PostProcessingState
extends BaseAppState {
    private FilterPostProcessor fpp;
    private DropShadowFilter shadows;
    private BloomFilter bloom;

    public BloomFilter getBloomFilter() {
        return this.bloom;
    }

    protected void initialize(Application app) {
        AssetManager assets = app.getAssetManager();
        this.fpp = new FilterPostProcessor(assets);
        AppSettings appSettings = app.getContext().getSettings();
        if (appSettings.getSamples() != 0) {
            this.fpp.setNumSamples(appSettings.getSamples());
        }
        this.shadows = new DropShadowFilter();
        this.shadows.setEnabled(true);
        this.fpp.addFilter((Filter)this.shadows);
        this.bloom = new BloomFilter();
        this.bloom.setEnabled(true);
        this.bloom.setDownSamplingFactor(4.0f);
        this.bloom.setBlurScale(1.0f);
        this.bloom.setExposurePower(10.0f);
        this.bloom.setExposureCutOff(0.2f);
        this.bloom.setBloomIntensity(0.3f);
        this.fpp.addFilter((Filter)this.bloom);
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        this.getApplication().getViewPort().addProcessor((SceneProcessor)this.fpp);
    }

    public void update(float tpf) {
    }

    protected void onDisable() {
        this.getApplication().getViewPort().removeProcessor((SceneProcessor)this.fpp);
    }
}

