/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.texture.Texture;
import com.simsilica.lemur.LayerComparator;
import com.simsilica.mathd.Vec3i;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AreaField
extends Geometry {
    static Logger log = LoggerFactory.getLogger(AreaField.class);
    private Vec3i min;
    private Vec3i max;
    private int height = 10;
    private Mesh mesh;
    private boolean invalid = true;
    private ColorRGBA color = ColorRGBA.Red;

    public AreaField(AssetManager assets, Vec3i min, Vec3i max) {
        this.min = min;
        this.max = max;
        LayerComparator.setLayer((Spatial)this, (int)9);
        this.mesh = new Mesh();
        this.setMesh(this.mesh);
        Material mat = new Material(assets, "MatDefs/ForceField.j3md");
        Texture noise = assets.loadTexture("Textures/noise-x3-512.png");
        mat.setTexture("ColorMap", noise);
        mat.setColor("Color", this.color);
        noise.setWrap(Texture.WrapMode.Repeat);
        mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        this.setMaterial(mat);
        this.setQueueBucket(RenderQueue.Bucket.Transparent);
    }

    public void setColor(ColorRGBA color) {
        if (Objects.equals(this.color, color)) {
            return;
        }
        this.color = color;
        this.getMaterial().setColor("Color", color);
    }

    public ColorRGBA getColor() {
        return this.color;
    }

    public void setArea(Vec3i min, Vec3i max) {
        if (!Objects.equals(this.min, min)) {
            this.min = min;
            this.invalid = true;
        }
        if (!Objects.equals(this.max, max)) {
            this.max = max;
            this.invalid = true;
        }
    }

    public Vec3i getMin() {
        return this.min;
    }

    public Vec3i getMax() {
        return this.max;
    }

    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        if (this.invalid) {
            this.updateMesh();
            this.invalid = false;
        }
    }

    protected void updateMesh() {
        log.info("updateMesh(" + this.min + ", " + this.max + ")");
        Mesh mesh = this.getMesh();
        float inset = 0.1f;
        float minx = (float)this.min.x + inset;
        float minz = (float)this.min.z + inset;
        float maxx = (float)(this.max.x + 1) - inset;
        float maxz = (float)(this.max.z + 1) - inset;
        float y = this.min.y;
        float xDist = maxx - minx;
        float zDist = maxz - minz;
        mesh.setBuffer(VertexBuffer.Type.Position, 3, new float[]{minx, y, minz, maxx, y, minz, maxx, y + (float)this.height, minz, minx, y + (float)this.height, minz, maxx, y, maxz, minx, y, maxz, minx, y + (float)this.height, maxz, maxx, y + (float)this.height, maxz, maxx, y, minz, maxx, y, maxz, maxx, y + (float)this.height, maxz, maxx, y + (float)this.height, minz, minx, y, maxz, minx, y, minz, minx, y + (float)this.height, minz, minx, y + (float)this.height, maxz, maxx, y, minz, minx, y, minz, minx, y - (float)this.height, minz, maxx, y - (float)this.height, minz, minx, y, maxz, maxx, y, maxz, maxx, y - (float)this.height, maxz, minx, y - (float)this.height, maxz, maxx, y, maxz, maxx, y, minz, maxx, y - (float)this.height, minz, maxx, y - (float)this.height, maxz, minx, y, minz, minx, y, maxz, minx, y - (float)this.height, maxz, minx, y - (float)this.height, minz});
        mesh.setBuffer(VertexBuffer.Type.TexCoord, 2, new float[]{0.0f, 0.0f, xDist, 0.0f, xDist, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, xDist, 0.0f, xDist, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, zDist, 0.0f, zDist, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, zDist, 0.0f, zDist, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, xDist, 0.0f, xDist, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, xDist, 0.0f, xDist, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, zDist, 0.0f, zDist, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, zDist, 0.0f, zDist, 1.0f, 0.0f, 1.0f});
        mesh.setBuffer(VertexBuffer.Type.Index, 3, new short[]{0, 1, 2, 0, 2, 3, 4, 5, 6, 4, 6, 7, 8, 9, 10, 8, 10, 11, 12, 13, 14, 12, 14, 15, 16, 17, 18, 16, 18, 19, 20, 21, 22, 20, 22, 23, 24, 25, 26, 24, 26, 27, 28, 29, 30, 28, 30, 31, 0, 2, 1, 0, 3, 2, 4, 6, 5, 4, 7, 6, 8, 10, 9, 8, 11, 10, 12, 14, 13, 12, 15, 14, 16, 18, 17, 16, 19, 18, 20, 22, 21, 20, 23, 22, 24, 26, 25, 24, 27, 26, 28, 30, 29, 28, 31, 30});
        mesh.updateBound();
        this.updateModelBound();
    }
}

