/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.BaseAppState;
import com.jme3.asset.AssetKey;
import com.jme3.audio.AudioData;
import com.jme3.audio.AudioKey;
import com.jme3.audio.AudioNode;
import com.jme3.audio.Listener;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityData;
import com.simsilica.es.Filters;
import com.simsilica.ethereal.TimeSource;
import com.simsilica.ext.mphys.SpawnPosition;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.mathd.Grid;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.state.DebugHudState;
import java.util.Objects;
import mythruna.GameConstants;
import mythruna.client.GameSessionState;
import mythruna.client.GameSettingsState;
import mythruna.client.view.AvatarState;
import mythruna.client.view.WorldViewState;
import mythruna.es.SoundInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoundViewState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(SoundViewState.class);
    private WorldViewState worldState;
    private EntityData ed;
    private VersionedReference<Vec3d> posRef;
    private AvatarState avatar;
    private Grid grid = GameConstants.PHYSICS_GRID;
    private Node soundRoot;
    private Vec3i centerCell = new Vec3i(0, -10000, 0);
    private Vec3i centerWorld;
    private Vec3i soundCenter = new Vec3i();
    private int soundGridRadius = 1;
    private ComponentFilter[][] gridFilters;
    private TimeSource timeSource;
    private SoundContainer sounds;
    private VersionedHolder<String> soundCount;
    private VersionedReference<Boolean> muteRef;
    private VersionedReference<Double> ambientVolumeRef;
    private VersionedReference<Double> effectsVolumeRef;
    private Listener originalListener;
    private Listener ears = new Listener();

    protected void initialize(Application app) {
        this.ed = ((GameSessionState)this.getState(GameSessionState.class)).getEntityData();
        this.timeSource = ((GameSessionState)this.getState(GameSessionState.class)).getTimeSource();
        this.soundRoot = new Node("soundRoot");
        this.worldState = (WorldViewState)this.getState(WorldViewState.class, true);
        this.avatar = (AvatarState)this.getState(AvatarState.class, true);
        this.muteRef = ((GameSettingsState)this.getState(GameSettingsState.class, true)).createMuteReference();
        this.ambientVolumeRef = ((GameSettingsState)this.getState(GameSettingsState.class, true)).createAmbientVolumeReference();
        this.effectsVolumeRef = ((GameSettingsState)this.getState(GameSettingsState.class, true)).createEffectsVolumeReference();
        DebugHudState debug = (DebugHudState)this.getState(DebugHudState.class);
        if (debug != null) {
            this.soundCount = debug.createDebugValue("Sounds", DebugHudState.Location.Right);
        }
        this.sounds = new SoundContainer(this.ed);
        this.originalListener = app.getListener();
        app.getAudioRenderer().setListener(this.ears);
        this.posRef = ((AvatarState)this.getState(AvatarState.class)).createPositionReference();
        this.updateViewPosition((Vec3d)this.posRef.get(), true);
    }

    protected void cleanup(Application app) {
        app.getAudioRenderer().setListener(this.originalListener);
    }

    protected void onEnable() {
        ((SimpleApplication)this.getApplication()).getRootNode().attachChild((Spatial)this.soundRoot);
        this.sounds.start();
    }

    protected void onDisable() {
        this.soundRoot.removeFromParent();
        this.sounds.stop();
    }

    public void update(float tpf) {
        if (this.posRef.update()) {
            this.updateViewPosition((Vec3d)this.posRef.get(), false);
            Vec3d loc = this.avatar.getEyePosition().subtract(this.centerWorld);
            this.ears.setLocation(loc.toVector3f());
        }
        this.ears.setRotation(this.avatar.getCameraFacing().toQuaternion());
        boolean volumeChanged = false;
        if (this.muteRef.update()) {
            volumeChanged = true;
        }
        if (this.effectsVolumeRef.update()) {
            volumeChanged = true;
        }
        if (volumeChanged) {
            this.resetVolume();
        }
        this.sounds.update();
        if (this.soundCount != null) {
            this.soundCount.setObject((Object)String.valueOf(this.sounds.size()));
        }
    }

    protected void updateViewPosition(Vec3d center, boolean forceUpdate) {
        Vec3i newCenter = this.grid.worldToCell(center);
        if (!forceUpdate && newCenter.equals((Object)this.centerCell)) {
            return;
        }
        this.centerCell.set(newCenter);
        this.centerWorld = this.grid.cellToWorld(this.centerCell);
        log.info("centerWorld:" + this.centerWorld);
        this.resetRelativeCoordinates();
        if (this.soundCenter.x != this.centerCell.x || this.soundCenter.z != this.centerCell.z) {
            this.soundCenter.x = this.centerCell.x;
            this.soundCenter.z = this.centerCell.z;
            this.resetSoundFilter();
        }
    }

    protected void resetRelativeCoordinates() {
        for (SoundView view : this.sounds.getArray()) {
            view.updateRelativePosition();
        }
    }

    protected void resetSoundFilter() {
        int size = this.soundGridRadius * 2 + 1;
        this.gridFilters = new ComponentFilter[size][size];
        ComponentFilter[] filters = new ComponentFilter[size * size];
        int xOffset = this.soundCenter.x - this.soundGridRadius;
        int zOffset = this.soundCenter.z - this.soundGridRadius;
        int index = 0;
        for (int x = 0; x < size; ++x) {
            for (int z = 0; z < size; ++z) {
                ComponentFilter filter;
                long id = this.grid.cellToId(xOffset + x, 0, zOffset + z);
                this.gridFilters[x][z] = filter = Filters.fieldEquals(SpawnPosition.class, (String)"binId", (Object)id);
                filters[index++] = filter;
            }
        }
        long start = System.nanoTime();
        this.sounds.setFilter(Filters.or(SpawnPosition.class, (ComponentFilter[])filters));
        long end = System.nanoTime();
    }

    protected double getEffectsVolume() {
        if (this.muteRef == null || this.effectsVolumeRef == null) {
            return 0.0;
        }
        if (((Boolean)this.muteRef.get()).booleanValue()) {
            return 0.0;
        }
        return (Double)this.effectsVolumeRef.get() / 100.0;
    }

    protected void resetVolume() {
        for (SoundView view : this.sounds.getArray()) {
            view.resetVolume();
        }
    }

    private class SoundContainer
    extends EntityContainer<SoundView> {
        public SoundContainer(EntityData ed) {
            super(ed, new Class[]{SoundInfo.class, SpawnPosition.class});
        }

        public void setFilter(ComponentFilter filter) {
            super.setFilter(filter);
        }

        public SoundView[] getArray() {
            return (SoundView[])super.getArray();
        }

        protected SoundView addObject(Entity e) {
            SoundView object = new SoundView(e);
            this.updateObject(object, e);
            return object;
        }

        protected void updateObject(SoundView object, Entity e) {
            object.update(e);
        }

        protected void removeObject(SoundView object, Entity e) {
            object.release();
        }
    }

    private class SoundView {
        private Entity entity;
        private AudioNode audio;
        private Spatial debugSpatial;
        private int useCount;
        private boolean dynamic;
        private SpawnPosition pos;
        private SoundInfo soundInfo;
        private int visibleCount;
        private Vec3d worldPos;

        public SoundView(Entity entity) {
            this.entity = entity;
            log.info("new SoundView(" + entity + ")");
        }

        public void setPosition(SpawnPosition pos) {
            this.pos = pos;
            this.setWorldPosition(pos.getLocation());
            this.updateRelativePosition();
        }

        public void setSound(SoundInfo soundInfo) {
            if (Objects.equals(this.soundInfo, soundInfo)) {
                return;
            }
            this.soundInfo = soundInfo;
            if (this.audio != null) {
                log.info("replacing, stopping and removing:" + this.audio);
                this.audio.stop();
                this.audio.removeFromParent();
            }
            log.info("playing:" + soundInfo.getSoundName(SoundViewState.this.ed) + " at:" + this.pos + "  volume:" + SoundViewState.this.getEffectsVolume());
            AudioKey key = new AudioKey(soundInfo.getSoundName(SoundViewState.this.ed), true, true);
            SoundViewState.this.getApplication().getAssetManager().deleteFromCache((AssetKey)key);
            AudioData data = SoundViewState.this.getApplication().getAssetManager().loadAudio(key);
            log.info("audio data type:" + data.getDataType() + "  duration:" + data.getDuration() + " channels:" + data.getChannels());
            this.audio = new AudioNode(data, key);
            this.audio.setPositional(true);
            this.audio.setVolume((float)(SoundViewState.this.getEffectsVolume() * soundInfo.getVolume()));
            this.audio.setRefDistance(1.0f);
            this.audio.setMaxDistance(200.0f);
            this.audio.setLooping(soundInfo.isLooping());
            this.audio.play();
            SoundViewState.this.soundRoot.attachChild((Spatial)this.audio);
            Box box = new Box(0.25f, 0.25f, 0.25f);
            this.debugSpatial = new Geometry("testBox", (Mesh)box);
            this.debugSpatial.setMaterial(GuiGlobals.getInstance().createMaterial(ColorRGBA.Red, true).getMaterial());
            this.audio.attachChild(this.debugSpatial);
            this.updateRelativePosition();
        }

        public void update(Entity entity) {
            log.info("update(" + entity + ")");
            this.setPosition((SpawnPosition)entity.get(SpawnPosition.class));
            this.setSound((SoundInfo)entity.get(SoundInfo.class));
        }

        public void release() {
            log.info("release(" + this.entity + ")");
            if (this.audio != null) {
                log.info("releasing, stopping and removing:" + this.audio);
                this.audio.stop();
                this.audio.removeFromParent();
            }
        }

        public void resetVolume() {
            if (this.audio != null) {
                log.info("resetVolume:" + SoundViewState.this.getEffectsVolume());
                this.audio.setVolume((float)(SoundViewState.this.getEffectsVolume() * this.soundInfo.getVolume()));
            }
        }

        public void setWorldPosition(Vec3d worldPos) {
            this.worldPos = worldPos;
            this.updateRelativePosition();
        }

        public void updateRelativePosition() {
            Vec3d loc = this.pos.getLocation();
            loc = loc.subtract(SoundViewState.this.centerWorld.toVec3d());
            if (this.audio != null) {
                log.info("audio pos:" + loc);
                this.audio.setLocalTranslation(loc.toVector3f());
                this.audio.setLocalRotation(this.pos.getOrientation().toQuaternion());
            }
        }
    }
}

