/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.tree;

import com.simsilica.mblock.BlockName;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mblock.MaskUtils;
import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.tree.AbstractTreeType;
import com.simsilica.mworld.tile.tree.AtlasCell;
import com.simsilica.mworld.tile.tree.TileColumnCells;
import com.simsilica.mworld.tile.tree.Tree;
import com.simsilica.mworld.tile.tree.TreeType;
import com.simsilica.mworld.tile.tree.TreeTypeIndex;
import java.io.Serializable;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTreeType
extends AbstractTreeType
implements Serializable {
    static Logger log = LoggerFactory.getLogger(SimpleTreeType.class);
    static final long serialVersionUID = 42L;
    private int typeTrunk1;
    private int typeTrunk2;
    private int typeLeaves1;
    private int typeLeaves2;
    private AtlasCell altCell;

    public SimpleTreeType(String name, AtlasCell atlasCell) {
        super(name, atlasCell);
        this.altCell = new AtlasCell(atlasCell.getAtlasName(), atlasCell.getIndex() + 1);
    }

    public void initialize(TreeTypeIndex treeTypes) {
        this.typeLeaves1 = BlockTypeIndex.findType((BlockName)new BlockName("leaves", "leaf")) | TREE_BITS;
        this.typeLeaves2 = BlockTypeIndex.findType((BlockName)new BlockName("leaves2", "leaf")) | TREE_BITS;
        this.typeTrunk1 = BlockTypeIndex.findType((BlockName)new BlockName("trunk", "vcyl")) | TREE_BITS;
        this.typeTrunk2 = BlockTypeIndex.findType((BlockName)new BlockName("trunk", "vcyl25")) | TREE_BITS;
    }

    public AtlasCell getAtlasCell(Tree tree) {
        if (tree.height < 6) {
            return super.getAtlasCell(tree);
        }
        return this.altCell;
    }

    public Tree createTree(short x, short y, short z, TerrainImage terrain, Random rand) {
        int height = rand.nextInt(4) + 4;
        return new Tree(x, y, z, (byte)(++height), 2, (TreeType)this);
    }

    public boolean markTree(Tree tree, boolean[][] used) {
        if (tree.height < 5) {
            return super.markTree(tree, used);
        }
        short i = tree.x;
        short k = tree.z;
        int w = 2;
        for (int x = i - w; x <= i + w; ++x) {
            for (int z = k - w; z <= k + w; ++z) {
                if (x == i && z == k || x == i - w && z == k - w || x == i + w && z == k - w || x == i - w && z == k + w || x == i + w && z == k + w) continue;
                used[x][z] = true;
            }
        }
        return true;
    }

    public boolean insertTree(Tree tree, TileColumnCells cells, Random rand) {
        int low;
        int height = tree.height - 1;
        int start = tree.y;
        int end = tree.y + height;
        int trunkType = this.typeTrunk1;
        int leafType = this.typeLeaves1;
        if (height < 6) {
            trunkType = this.typeTrunk2;
        }
        if (height < 5) {
            leafType = this.typeLeaves2;
        }
        short i = tree.x;
        short k = tree.z;
        cells.setCell((int)i, end, (int)k, leafType);
        cells.setCell((int)i, end - 1, (int)k, leafType);
        for (int z = start; z < end - 1; ++z) {
            cells.setCell((int)i, z, (int)k, trunkType);
        }
        if (height < 5) {
            low = start + Math.max(1, height / 3);
            short w = 1;
            for (int y = end - 1; y >= low; --y) {
                for (int x = i - w; x <= i + w; ++x) {
                    for (int z = k - w; z <= k + w; ++z) {
                        if (x == i && z == k) continue;
                        cells.setCell(x, y, z, leafType);
                    }
                }
            }
        } else {
            low = start + height * 2 / 3;
            if (trunkType == this.typeTrunk1) {
                --low;
            }
            int w = 1;
            for (int y = end; y >= low; --y) {
                if (y == low) {
                    w = 1;
                } else if (y < end) {
                    w = 2;
                }
                for (int x = i - w; x <= i + w; ++x) {
                    for (int z = k - w; z <= k + w; ++z) {
                        if (x == i && z == k || w == 2 && (x == i - w && z == k - w || x == i + w && z == k - w || x == i - w && z == k + w || x == i + w && z == k + w)) continue;
                        cells.setCell(x, y, z, leafType);
                    }
                }
            }
        }
        return true;
    }

    public boolean insertTree(Tree tree, TerrainImage terrain) {
        short i = tree.x;
        short k = tree.z;
        int w = 2;
        for (int x = i - w; x <= i + w; ++x) {
            for (int z = k - w; z <= k + w; ++z) {
                if (x == i && z == k) {
                    terrain.setLight(x, z, (byte)-15);
                    continue;
                }
                if (x == i - w && z == k - w || x == i + w && z == k - w || x == i - w && z == k + w || x == i + w && z == k + w) continue;
                terrain.setLight(x, z, (byte)-7);
            }
        }
        return true;
    }

    public boolean isBlock(Tree tree, int x, int y, int z, int type) {
        if (x < -tree.radius || z < -tree.radius) {
            return false;
        }
        if (x > tree.radius || z > tree.radius) {
            return false;
        }
        if (y < 0 || y > tree.height) {
            return false;
        }
        int height = tree.height - 1;
        int trunkType = MaskUtils.getType((int)this.typeTrunk1);
        int leafType = MaskUtils.getType((int)this.typeLeaves1);
        if (height < 6) {
            trunkType = MaskUtils.getType((int)this.typeTrunk2);
        }
        if (height < 5) {
            leafType = MaskUtils.getType((int)this.typeLeaves2);
        }
        if (x == 0 && z == 0) {
            if (y == height || y == height - 1) {
                return type == leafType;
            }
            return type == trunkType;
        }
        if (height < 5) {
            int low = Math.max(1, height / 3);
            if (y < low) {
                return false;
            }
            if (Math.abs(x) <= 1 && Math.abs(z) <= 1) {
                return type == leafType;
            }
            return false;
        }
        int low = height * 2 / 3;
        if (trunkType == this.typeTrunk1) {
            --low;
        }
        if (y < low) {
            return false;
        }
        int w = 1;
        if (y < height) {
            w = 2;
        }
        if (w == 2) {
            if (Math.abs(x) == w && Math.abs(z) == w) {
                return false;
            }
            return type == leafType;
        }
        if (Math.abs(x) > w || Math.abs(z) > w) {
            return false;
        }
        return type == leafType;
    }
}

