/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mphys;

import com.google.common.base.Predicate;
import com.simsilica.mathd.Rayd;
import com.simsilica.mphys.AbstractShape;
import com.simsilica.mphys.ContactListener;
import com.simsilica.mphys.HitResults;
import com.simsilica.mphys.RigidBody;
import com.simsilica.mphys.StaticBody;

public interface CollisionSystem<K, S extends AbstractShape> {
    public void generateWorldCollisions(RigidBody<K, S> var1, ContactListener<K, S> var2);

    public void generateStaticCollisions(RigidBody<K, S> var1, StaticBody<K, S>[] var2, ContactListener<K, S> var3);

    public void generateBodyCollisions(RigidBody<K, S> var1, RigidBody<K, S>[] var2, ContactListener<K, S> var3);

    public void generateBodyCollisions(RigidBody<K, S>[] var1, ContactListener<K, S> var2);

    public void generateStaticCollisions(RigidBody<K, S> var1, StaticBody<K, S>[] var2, Predicate<? super StaticBody<K, S>> var3, ContactListener<K, S> var4);

    public void generateBodyCollisions(RigidBody<K, S> var1, RigidBody<K, S>[] var2, Predicate<? super RigidBody<K, S>> var3, ContactListener<K, S> var4);

    public void queryWorldHits(Rayd var1, HitResults<K, S> var2);

    public void queryBodyHits(Rayd var1, RigidBody<K, S>[] var2, HitResults<K, S> var3);

    public void queryStaticHits(Rayd var1, StaticBody<K, S>[] var2, HitResults<K, S> var3);
}

