/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.ethereal;

import com.simsilica.ethereal.LocalZoneIndex;
import com.simsilica.ethereal.SharedObjectSpace;
import com.simsilica.ethereal.net.ObjectState;
import com.simsilica.ethereal.zone.ZoneKey;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedObject {
    static Logger log = LoggerFactory.getLogger(SharedObject.class);
    private final SharedObjectSpace space;
    private long version;
    private final ObjectState current;
    private long baselineVersion;
    private ObjectState baseline;
    private ZoneKey zone;
    private boolean notifiedRemoved;

    public SharedObject(SharedObjectSpace space, int networkId, Long realId) {
        this.space = space;
        this.current = new ObjectState(networkId, realId);
    }

    public int getNetworkId() {
        return this.current.networkId;
    }

    public Long getEntityId() {
        return this.current.realId;
    }

    public Long getParentId() {
        return this.current.parentId == ObjectState.NO_PARENT ? null : this.current.parentId;
    }

    public long getVersion() {
        return this.version;
    }

    public ObjectState getDelta() {
        return this.current.getDelta(this.baseline);
    }

    public Vec3d getWorldPosition() {
        Vec3d result = this.space.getObjectProtocol().getPosition(this.current);
        if (this.getParentId() == null) {
            return this.zone.toWorld(result, result);
        }
        return result;
    }

    public Quatd getWorldRotation() {
        return this.space.getObjectProtocol().getRotation(this.current);
    }

    public boolean isMarkedRemoved() {
        return this.current.isMarkedRemoved();
    }

    public boolean isFullyMarkedRemoved() {
        if (this.baseline == null) {
            return false;
        }
        return this.baseline.isMarkedRemoved() && this.current.isMarkedRemoved();
    }

    public void markRemoved(long time) {
        if (time > this.version) {
            this.current.markRemoved();
        }
    }

    public void markNotifiedRemoved(boolean b) {
        this.notifiedRemoved = b;
    }

    public boolean isNotifiedRemoved() {
        return this.notifiedRemoved;
    }

    public boolean updateState(long time, ZoneKey zone, int zoneId, Long parentId, Vec3d pos, Quatd rot) {
        if (time <= this.version) {
            return false;
        }
        if (this.current.isMarkedRemoved() && log.isDebugEnabled()) {
            log.debug("Unremoving:" + this.current.realId);
        }
        this.version = time;
        this.zone = zone;
        this.current.zoneId = zoneId;
        this.current.parentId = parentId == null ? ObjectState.NO_PARENT : parentId;
        Vec3d localPos = parentId == null ? zone.toLocal(pos) : pos;
        this.space.getObjectProtocol().setPosition(this.current, localPos);
        this.space.getObjectProtocol().setRotation(this.current, rot);
        return true;
    }

    public boolean updateBaseline(long sequence, ObjectState state) {
        if (this.baseline == null) {
            this.baseline = state.clone();
            if (this.baseline.realId == null) {
                log.warn("initial baseline contains no realId, networkId:" + state.networkId + ", current realId:" + this.current.realId);
                this.baseline.realId = this.current.realId;
            }
            return true;
        }
        if (this.baselineVersion > sequence) {
            return false;
        }
        this.baselineVersion = sequence;
        this.baseline.applyDelta(state);
        return true;
    }

    public boolean applyNetworkState(long sequence, ObjectState state, LocalZoneIndex zoneIndex) {
        if (log.isDebugEnabled()) {
            log.debug("applyNetworkState(" + sequence + ", " + state + ")");
        }
        if (this.version > sequence) {
            if (log.isDebugEnabled()) {
                log.debug("********** Already have newer state for:" + this.current.realId);
            }
            return false;
        }
        this.version = sequence;
        if (this.baseline != null) {
            this.current.set(this.baseline);
        }
        this.current.applyDelta(state);
        if (this.current.zoneId == -1 || this.current.realId == null) {
            log.error("Error updating state, baseline=" + this.baseline + " current:" + this.current + " update:" + state);
        }
        if (this.current.zoneId != -1) {
            this.zone = zoneIndex.getZone(this.current.zoneId, this.zone);
        } else {
            log.warn("No zoneID set for object with ID:" + this.current.realId);
        }
        if (!this.isMarkedRemoved()) {
            this.notifiedRemoved = false;
            this.space.objectUpdated(this);
        } else if (!this.notifiedRemoved) {
            this.notifiedRemoved = true;
            this.space.objectRemoved(this);
        }
        return true;
    }
}

