/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.ethereal.zone;

import com.simsilica.ethereal.zone.StateBlock;
import com.simsilica.ethereal.zone.StateFrame;
import com.simsilica.ethereal.zone.StateListener;
import com.simsilica.ethereal.zone.ZoneKey;
import com.simsilica.ethereal.zone.ZoneManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateCollector {
    static Logger log = LoggerFactory.getLogger(StateCollector.class);
    private static final long NANOS_PER_SEC = 1000000000L;
    public static final long DEFAULT_PERIOD = 50000000L;
    private ZoneManager zones;
    private long collectionPeriod;
    private long idleSleepTime = 1L;
    private final Runner runner = new Runner();
    private final Set<StateListener> listeners = new CopyOnWriteArraySet<StateListener>();
    private final ConcurrentLinkedQueue<StateListener> removed = new ConcurrentLinkedQueue();
    private final Map<ZoneKey, List<StateListener>> zoneListeners = new HashMap<ZoneKey, List<StateListener>>();

    public StateCollector(ZoneManager zones) {
        this(zones, 50000000L);
    }

    public StateCollector(ZoneManager zones, long collectionPeriod) {
        this.zones = zones;
        this.collectionPeriod = collectionPeriod == 0L ? 50000000L : collectionPeriod;
    }

    public void start() {
        log.info("Starting state collector.");
        this.runner.start();
    }

    public void shutdown() {
        log.info("Shutting down state collector.");
        this.runner.close();
    }

    public void addListener(StateListener l) {
        this.listeners.add(l);
    }

    public void removeListener(StateListener l) {
        this.listeners.remove(l);
        this.removed.add(l);
    }

    public void setIdleSleepTime(long millis) {
        this.idleSleepTime = millis;
    }

    public long getIdleSleepTime() {
        return this.idleSleepTime;
    }

    protected List<StateListener> getListeners(ZoneKey key, boolean create) {
        List<StateListener> result = this.zoneListeners.get(key);
        if (result == null && create) {
            result = new ArrayList<StateListener>();
            this.zoneListeners.put(key, result);
        }
        return result;
    }

    protected void watch(ZoneKey key, StateListener l) {
        if (log.isTraceEnabled()) {
            log.trace("watch(" + key + ", " + l + ")");
        }
        this.getListeners(key, true).add(l);
    }

    protected void unwatch(ZoneKey key, StateListener l) {
        List<StateListener> list;
        if (log.isTraceEnabled()) {
            log.trace("unwatch(" + key + ", " + l + ")");
        }
        if ((list = this.getListeners(key, false)) == null) {
            return;
        }
        list.remove(l);
    }

    protected void unwatchAll(StateListener l) {
        if (log.isTraceEnabled()) {
            log.trace("unwatchAll(" + l + ")");
        }
        for (List<StateListener> list : this.zoneListeners.values()) {
            list.remove(l);
        }
    }

    protected void initialize() {
        this.zones.setCollectHistory(true);
    }

    protected void publish(StateBlock b) {
        List<StateListener> list = this.getListeners(b.getZone(), false);
        if (list == null) {
            return;
        }
        for (StateListener l : list) {
            l.stateChanged(b);
        }
    }

    protected void publishFrame(StateFrame frame) {
        log.trace("publishFrame()");
        for (StateListener l : this.listeners) {
            if (l.hasChangedZones()) {
                List<ZoneKey> exited = l.getExitedZones();
                for (ZoneKey k : exited) {
                    this.unwatch(k, l);
                }
                List<ZoneKey> entered = l.getEnteredZones();
                for (ZoneKey k : entered) {
                    this.watch(k, l);
                }
            }
            l.beginFrame(frame.getTime());
        }
        for (StateBlock b : frame) {
            this.publish(b);
        }
        for (StateListener l : this.listeners) {
            l.endFrame(frame.getTime());
        }
        log.trace("end publishFrame()");
    }

    protected void collect() {
        StateListener remove;
        log.trace("collect()");
        while ((remove = this.removed.poll()) != null) {
            this.unwatchAll(remove);
        }
        StateFrame[] frames = this.zones.purgeState();
        for (StateListener l : this.listeners) {
            l.beginFrameBlock();
        }
        for (StateFrame f : frames) {
            if (f == null) continue;
            this.publishFrame(f);
        }
        for (StateListener l : this.listeners) {
            l.endFrameBlock();
        }
        log.trace("end collect()");
    }

    protected void terminate() {
        this.zones.setCollectHistory(false);
    }

    protected void collectionError(Exception e) {
        log.error("Collection error", (Throwable)e);
    }

    private class Runner
    extends Thread {
        private final AtomicBoolean go = new AtomicBoolean(true);

        public Runner() {
            this.setName("StateCollectionThread");
        }

        public void close() {
            this.go.set(false);
            try {
                this.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted while waiting for physic thread to complete.", e);
            }
        }

        @Override
        public void run() {
            StateCollector.this.initialize();
            long lastTime = System.nanoTime();
            long counter = 0L;
            long nextCountTime = lastTime + 1000000000L;
            while (this.go.get()) {
                long time = System.nanoTime();
                long delta = time - lastTime;
                if (delta >= StateCollector.this.collectionPeriod) {
                    lastTime = time;
                    try {
                        StateCollector.this.collect();
                        ++counter;
                    }
                    catch (Exception e) {
                        StateCollector.this.collectionError(e);
                    }
                    if (lastTime <= nextCountTime) continue;
                    if (counter < 20L) {
                        System.out.println("collect underflow FPS:" + counter);
                    }
                    counter = 0L;
                    nextCountTime = lastTime + 1000000000L;
                    continue;
                }
                try {
                    if (StateCollector.this.idleSleepTime <= 0L) continue;
                    Thread.sleep(StateCollector.this.idleSleepTime);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Interrupted sleeping", e);
                }
            }
            StateCollector.this.terminate();
        }
    }
}

