/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.ext.mphys.debug;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.BaseAppState;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.debug.WireBox;
import com.jme3.texture.Texture;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.input.FunctionId;
import com.simsilica.mathd.Grid;
import com.simsilica.mathd.GridCell;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mphys.AbstractShape;
import com.simsilica.mphys.Bin;
import com.simsilica.mphys.BinIndex;
import com.simsilica.mphys.BinListener;
import com.simsilica.mphys.PhysicsListener;
import com.simsilica.mphys.PhysicsSpace;
import com.simsilica.mphys.RigidBody;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinStatusState<S extends AbstractShape>
extends BaseAppState {
    public static final FunctionId F_PHYSICS_DUMP = new FunctionId("Physics Dump");
    static Logger log = LoggerFactory.getLogger(BinStatusState.class);
    private PhysicsSpace space;
    private Grid grid;
    private Node binRoot;
    private Camera camera;
    private Geometry boxTemplate;
    private double groundHeight;
    private Vec3d viewOrigin = new Vec3d();
    private Vec3i lastCenter = new Vec3i();
    private Vec3i lastCenterWorld = new Vec3i();
    private BinObserver binListener = new BinObserver();
    private ConcurrentLinkedQueue<BinEvent> binEvents = new ConcurrentLinkedQueue();
    private Map<GridCell, StatusView> statusIndex = new HashMap<GridCell, StatusView>();
    private int radius = 5;
    private PhysicsListener debugDumper = new DebugDumper();

    public BinStatusState(PhysicsSpace space) {
        this(space, 0.0f);
    }

    public BinStatusState(PhysicsSpace space, float groundHeight) {
        this.space = space;
        this.groundHeight = groundHeight;
        this.grid = space.getGrid();
        this.setEnabled(true);
    }

    public void logPhysicsState() {
        this.space.addPhysicsListener(this.debugDumper);
    }

    public void toggleEnabled() {
        this.setEnabled(!this.isEnabled());
    }

    public void setViewOrigin(double x, double y, double z) {
        this.viewOrigin.set(x, y, z);
    }

    public void setViewOrigin(Vec3d origin) {
        this.setViewOrigin(origin.x, origin.y, origin.z);
    }

    public Vec3d getViewOrigin() {
        return this.viewOrigin;
    }

    protected Node getRoot() {
        return ((SimpleApplication)this.getApplication()).getRootNode();
    }

    protected Camera getCamera() {
        if (this.camera == null) {
            this.camera = this.getApplication().getCamera();
        }
        return this.camera;
    }

    protected Geometry createBoxTemplate(Application app) {
        GuiGlobals globals = GuiGlobals.getInstance();
        Texture texture = globals.loadTexture("Interface/bottom-corners2.png", true, true);
        Material mat = globals.createMaterial(ColorRGBA.Pink, false).getMaterial();
        mat.setTexture("ColorMap", texture);
        mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        mat.getAdditionalRenderState().setDepthWrite(false);
        float xHalf = (float)this.grid.getSpacing().x * 0.5f;
        float zHalf = (float)this.grid.getSpacing().z * 0.5f;
        float height = 2.0f;
        WireBox box = new WireBox(xHalf * 0.995f, height * 0.995f, zHalf * 0.995f);
        box.setBuffer(VertexBuffer.Type.TexCoord, 2, new float[]{0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.5f, 0.0f, 0.5f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 1.0f, 0.5f});
        Geometry geom = new Geometry("boxTemplate", (Mesh)box);
        geom.setMaterial(mat);
        geom.setQueueBucket(RenderQueue.Bucket.Transparent);
        geom.setUserData("layer", (Object)4);
        geom.setLocalTranslation(xHalf, height, zHalf);
        return geom;
    }

    protected void initialize(Application app) {
        log.info("initialize()");
        this.binRoot = new Node("binRoot");
        this.boxTemplate = this.createBoxTemplate(app);
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        GuiGlobals.getInstance().getInputMapper().addDelegate(F_PHYSICS_DUMP, (Object)this, "logPhysicsState");
        this.getRoot().attachChild((Spatial)this.binRoot);
        this.space.addBinListener((BinListener)this.binListener);
        this.resetViews();
    }

    protected void onDisable() {
        GuiGlobals.getInstance().getInputMapper().removeDelegate(F_PHYSICS_DUMP, (Object)this, "logPhysicsState");
        this.space.removeBinListener((BinListener)this.binListener);
        this.binRoot.removeFromParent();
        this.statusIndex.clear();
    }

    public void update(float tpf) {
        if (!this.binEvents.isEmpty()) {
            BinEvent e = null;
            while ((e = this.binEvents.poll()) != null) {
                this.updateStatus(e.cell, e.status);
            }
        }
        this.updateCenter();
    }

    protected void resetViews() {
        Vector3f cameraPos = this.getCamera().getLocation();
        Vec3d world = this.viewOrigin.add(new Vec3d(cameraPos));
        Vec3i center = this.grid.worldToCell(world.x, 0.0, world.z);
        this.lastCenter.set(center);
        for (int x = center.x - this.radius; x <= center.x + this.radius; ++x) {
            for (int z = center.z - this.radius; z <= center.z + this.radius; ++z) {
                GridCell cell = this.grid.getGridCell(x, 0, z);
                Bin.Status status = this.space.getBinStatus(cell);
                this.updateStatus(cell, status);
            }
        }
        this.updatePositions();
    }

    protected void updateCenter() {
        Vector3f cameraPos = this.getCamera().getLocation();
        Vec3d world = this.viewOrigin.add(new Vec3d(cameraPos));
        Vec3i center = this.grid.worldToCell(world.x, 0.0, world.z);
        if (!center.equals((Object)this.lastCenter)) {
            this.lastCenter.set(center);
            Vec3i cellWorld = this.grid.cellToWorld(center, this.lastCenterWorld);
            this.updatePositions();
        }
        this.binRoot.setLocalTranslation((float)((double)this.lastCenterWorld.x - world.x), (float)this.lastCenterWorld.y, (float)((double)this.lastCenterWorld.z - world.z));
    }

    protected void updatePositions() {
        System.out.println("----- updatePositions() lastCenter:" + this.lastCenter);
        for (StatusView view : this.statusIndex.values()) {
            view.updatePosition(this.lastCenter);
        }
    }

    private StatusView getView(GridCell cell, boolean create) {
        StatusView existing = this.statusIndex.get(cell);
        if (existing == null && create) {
            existing = new StatusView(cell);
            this.statusIndex.put(cell, existing);
            existing.updatePosition(this.lastCenter);
        }
        return existing;
    }

    protected void updateStatus(GridCell cell, Bin.Status status) {
        if (status != null) {
            StatusView view = this.getView(cell, true);
            view.update(status);
            view.updatePosition(this.lastCenter);
        } else {
            this.remove(cell);
        }
    }

    private void remove(GridCell cell) {
        StatusView existing = this.statusIndex.remove(cell);
        if (existing != null) {
            existing.detach();
        }
    }

    private class DebugDumper
    implements PhysicsListener {
        private DebugDumper() {
        }

        public void startFrame(long frameTime, double stepSize) {
            StringWriter sOut = new StringWriter();
            PrintWriter out = new PrintWriter(sOut);
            BinStatusState.this.space.writeDebugInfo(out);
            out.close();
            log.info("Physics dump:\n" + sOut.toString());
            BinStatusState.this.space.removePhysicsListener((PhysicsListener)this);
        }

        public void update(RigidBody body) {
        }

        public void endFrame() {
        }
    }

    private class BinObserver
    implements BinListener<Integer, S> {
        private BinObserver() {
        }

        public void initialize(BinIndex<Integer, S> binIndex) {
        }

        public void terminate(BinIndex<Integer, S> binIndex) {
        }

        public void loaded(Bin<Integer, S> bin) {
            log.info("loaded(" + bin + ") thread:" + Thread.currentThread());
            BinStatusState.this.binEvents.add(new BinEvent(bin.getGridCell(), bin.getStatus()));
        }

        public void unloaded(Bin<Integer, S> bin) {
            log.info("unloaded(" + bin + ") thread:" + Thread.currentThread());
            BinStatusState.this.binEvents.add(new BinEvent(bin.getGridCell(), null));
        }

        public void statusChanged(Bin<Integer, S> bin, Bin.Status status) {
            log.info("stateChanged(" + bin + ", " + status + ") thread:" + Thread.currentThread());
            BinStatusState.this.binEvents.add(new BinEvent(bin.getGridCell(), bin.getStatus()));
        }
    }

    private class BinEvent {
        GridCell cell;
        Bin.Status status;

        public BinEvent(GridCell cell, Bin.Status status) {
            this.cell = cell;
            this.status = status;
        }
    }

    private class StatusView {
        Geometry view;
        GridCell cell;
        ColorRGBA color = new ColorRGBA(1.0f, 0.0f, 1.0f, 1.0f);

        public StatusView(GridCell cell) {
            this.cell = cell;
            this.view = BinStatusState.this.boxTemplate.clone(true);
            this.view.setName("view:" + cell);
            this.view.getMaterial().setColor("Color", this.color);
        }

        public void detach() {
            this.view.removeFromParent();
        }

        public void update(Bin.Status status) {
            switch (status) {
                case Empty: {
                    this.color.set(0.0f, 0.0f, 0.0f, 1.0f);
                    break;
                }
                case Static: {
                    this.color.set(0.0f, 0.0f, 1.0f, 1.0f);
                    break;
                }
                case Asleep: {
                    this.color.set(0.0f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case Active: {
                    this.color.set(1.0f, 0.0f, 0.0f, 1.0f);
                }
            }
        }

        public void updatePosition(Vec3i centerCell) {
            boolean visible;
            int xDelta = Math.abs(this.cell.getCell().x - centerCell.x);
            int zDelta = Math.abs(this.cell.getCell().z - centerCell.z);
            boolean bl = visible = xDelta <= 5 && zDelta <= 5;
            if (visible) {
                BinStatusState.this.binRoot.attachChild((Spatial)this.view);
            } else {
                this.view.removeFromParent();
            }
            double x = this.cell.getWorldOrigin().x - ((BinStatusState)BinStatusState.this).lastCenterWorld.x;
            double y = BinStatusState.this.groundHeight - (double)((BinStatusState)BinStatusState.this).lastCenterWorld.y;
            double z = this.cell.getWorldOrigin().z - ((BinStatusState)BinStatusState.this).lastCenterWorld.z;
            Vector3f offset = BinStatusState.this.boxTemplate.getLocalTranslation();
            this.view.setLocalTranslation((float)x + offset.x, (float)y + offset.y, (float)z + offset.z);
        }
    }
}

