/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.db;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.Direction;
import com.simsilica.mblock.LightUtils;
import com.simsilica.mworld.ColumnData;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.DataType;
import com.simsilica.mworld.FluidData;
import com.simsilica.mworld.LeafData;
import com.simsilica.mworld.LeafId;
import com.simsilica.mworld.LightData;
import com.simsilica.mworld.db.ColumnDb;
import com.simsilica.mworld.transaction.WorldTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnNeighborhood
implements CellData {
    static Logger log = LoggerFactory.getLogger(ColumnNeighborhood.class);
    private ColumnDb columnDb;
    private ColumnData center;
    private Vec3i world;
    private ColumnData[][] columns = new ColumnData[3][3];
    private CellData lightingCells;
    private CellData fluidCells;
    private WorldTransaction transaction;
    private boolean readOnlyNeighbors;

    public ColumnNeighborhood(ColumnDb columnDb, ColumnData center) {
        this(columnDb, center, null);
    }

    public ColumnNeighborhood(ColumnDb columnDb, ColumnData center, WorldTransaction transaction) {
        this(columnDb, center, transaction, false);
    }

    public ColumnNeighborhood(ColumnDb columnDb, ColumnData center, WorldTransaction transaction, boolean readOnlyNeighbors) {
        this.columnDb = columnDb;
        this.center = center;
        this.world = center.getColumnId().getWorld(null);
        this.transaction = transaction;
        this.readOnlyNeighbors = readOnlyNeighbors;
        this.columns[1][1] = center;
    }

    public CellData getLightingCellData() {
        if (this.lightingCells == null) {
            this.lightingCells = new LightingCellData();
        }
        return this.lightingCells;
    }

    public CellData getFluidCellData() {
        if (this.fluidCells == null) {
            this.fluidCells = new FluidCellData();
        }
        return this.fluidCells;
    }

    private ColumnData getColumn(int x, int z) {
        int i = (x + 32) / 32;
        int j = (z + 32) / 32;
        ColumnData col = this.columns[i][j];
        if (col == null) {
            ColumnId id = ColumnId.fromWorld(this.world.x + x, this.world.z + z);
            this.columns[i][j] = col = this.columnDb.getColumn(id);
        }
        return col;
    }

    private void markChanged(ColumnData col, CellData data, DataType type, LeafId id, int i, int j, int k, int value, int oldValue) {
        if (this.transaction != null) {
            if (log.isTraceEnabled()) {
                log.trace("markChanged(" + (Object)((Object)type) + ", " + i + ", " + j + ", " + k + ", " + Integer.toHexString(value) + ") original:" + Integer.toHexString(oldValue));
            }
            this.transaction.cellChanged(col, id, type, i, j, k, value, oldValue);
        }
    }

    public int getCell(int x, int y, int z) {
        return this.getCell(x, y, z, -1);
    }

    public int getCell(int x, int y, int z, int defaultValue) {
        if (y < 0) {
            return defaultValue;
        }
        ColumnData col = this.getColumn(x, z);
        if (col == null) {
            return defaultValue;
        }
        int k = y / 32;
        if (k >= col.getLighting().length) {
            return defaultValue;
        }
        LeafData leaf = col.getLeafs()[k];
        if (leaf == null) {
            return defaultValue;
        }
        if (leaf.isEmpty()) {
            return 0;
        }
        if (x < 0) {
            x += 32;
        } else if (x >= 32) {
            x -= 32;
        }
        if (z < 0) {
            z += 32;
        } else if (z >= 32) {
            z -= 32;
        }
        return leaf.getCell(x, y - k * 32, z);
    }

    public int getCell(int x, int y, int z, Direction dir, int defaultValue) {
        Vec3i v = dir.getVec3i();
        return this.getCell(x + v.x, y + v.y, z + v.z, defaultValue);
    }

    public void setCell(int x, int y, int z, int value) {
        ColumnData col;
        if (log.isTraceEnabled()) {
            log.trace("setCell(" + x + ", " + y + ", " + z + ", " + value + ")");
        }
        if ((col = this.getColumn(x, z)) == null) {
            throw new RuntimeException("ColumnData not found for:" + x + ", " + z);
        }
        if (col != this.center && this.readOnlyNeighbors) {
            return;
        }
        int xLocal = x;
        int zLocal = z;
        if (x < 0) {
            xLocal = x + 32;
        } else if (x >= 32) {
            xLocal = x - 32;
        }
        if (z < 0) {
            zLocal = z + 32;
        } else if (z >= 32) {
            zLocal = z - 32;
        }
        int k = y / 32;
        int yLocal = y - k * 32;
        LeafData leaf = col.getLeafs()[k];
        int existing = -1;
        if (this.transaction != null && (existing = leaf.getCell(xLocal, yLocal, zLocal, value)) == value) {
            return;
        }
        leaf.setCell(xLocal, yLocal, zLocal, value);
        this.markChanged(col, leaf, DataType.Block, leaf.getLeafId(), xLocal, yLocal, zLocal, value, existing);
    }

    public int getLight(int x, int y, int z, int defaultValue) {
        if (y < 0) {
            return defaultValue;
        }
        ColumnData col = this.getColumn(x, z);
        if (col == null) {
            return defaultValue;
        }
        int k = y / 32;
        if (k >= col.getLighting().length) {
            return LightUtils.DIRECT_SUN;
        }
        LightData lighting = col.getLighting()[k];
        if (lighting.isSolidDark()) {
            return -65536;
        }
        if (lighting.isFullSun()) {
            return LightUtils.DIRECT_SUN;
        }
        if (x < 0) {
            x += 32;
        } else if (x >= 32) {
            x -= 32;
        }
        if (z < 0) {
            z += 32;
        } else if (z >= 32) {
            z -= 32;
        }
        return lighting.getCell(x, y - k * 32, z);
    }

    public void setLight(int x, int y, int z, int value) {
        ColumnData col;
        if (log.isTraceEnabled()) {
            log.trace("setLight(" + x + ", " + y + ", " + z + ", " + value + ")");
        }
        if ((col = this.getColumn(x, z)) == null) {
            throw new RuntimeException("Column not found for:" + x + ", " + z);
        }
        if (col != this.center && this.readOnlyNeighbors) {
            return;
        }
        int xLocal = x;
        int zLocal = z;
        if (x < 0) {
            xLocal = x + 32;
        } else if (x >= 32) {
            xLocal = x - 32;
        }
        if (z < 0) {
            zLocal = z + 32;
        } else if (z >= 32) {
            zLocal = z - 32;
        }
        int k = y / 32;
        int yLocal = y - k * 32;
        LightData lighting = col.getLighting()[k];
        int existing = -1;
        if (this.transaction != null && (existing = lighting.getCell(xLocal, yLocal, zLocal, value)) == value) {
            return;
        }
        lighting.setCell(xLocal, yLocal, zLocal, value);
        this.markChanged(col, lighting, DataType.Light, lighting.getLeafId(), xLocal, yLocal, zLocal, value, existing);
    }

    public int getFluid(int x, int y, int z, int defaultValue) {
        if (y < 0) {
            return defaultValue;
        }
        ColumnData col = this.getColumn(x, z);
        if (col == null) {
            return defaultValue;
        }
        int k = y / 32;
        if (k >= col.getFluid().length) {
            return LightUtils.DIRECT_SUN;
        }
        FluidData fluidData = col.getFluid()[k];
        if (fluidData.isEmpty()) {
            return 0;
        }
        if (x < 0) {
            x += 32;
        } else if (x >= 32) {
            x -= 32;
        }
        if (z < 0) {
            z += 32;
        } else if (z >= 32) {
            z -= 32;
        }
        return fluidData.getCell(x, y - k * 32, z);
    }

    public void setFluid(int x, int y, int z, int value) {
        ColumnData col;
        if (log.isTraceEnabled()) {
            log.trace("setFluid(" + x + ", " + y + ", " + z + ", " + value + ")");
        }
        if ((col = this.getColumn(x, z)) == null) {
            throw new RuntimeException("Column not found for:" + x + ", " + z);
        }
        if (col != this.center && this.readOnlyNeighbors) {
            return;
        }
        int xLocal = x;
        int zLocal = z;
        if (x < 0) {
            xLocal = x + 32;
        } else if (x >= 32) {
            xLocal = x - 32;
        }
        if (z < 0) {
            zLocal = z + 32;
        } else if (z >= 32) {
            zLocal = z - 32;
        }
        int k = y / 32;
        int yLocal = y - k * 32;
        FluidData fluidData = col.getFluid()[k];
        int existing = -1;
        if (this.transaction != null && (existing = fluidData.getCell(xLocal, yLocal, zLocal, value)) == value) {
            return;
        }
        fluidData.setCell(xLocal, yLocal, zLocal, value);
        this.markChanged(col, fluidData, DataType.Fluid, fluidData.getLeafId(), xLocal, yLocal, zLocal, value, existing);
    }

    private class FluidCellData
    implements CellData {
        private FluidCellData() {
        }

        public int getCell(int x, int y, int z) {
            return ColumnNeighborhood.this.getFluid(x, y, z, -1);
        }

        public int getCell(int x, int y, int z, int defaultValue) {
            return ColumnNeighborhood.this.getFluid(x, y, z, defaultValue);
        }

        public int getCell(int x, int y, int z, Direction dir, int defaultValue) {
            Vec3i v = dir.getVec3i();
            return ColumnNeighborhood.this.getFluid(v.x + x, v.y + y, v.z + z, defaultValue);
        }

        public void setCell(int x, int y, int z, int fluid) {
            ColumnNeighborhood.this.setFluid(x, y, z, fluid);
        }
    }

    private class LightingCellData
    implements CellData {
        private LightingCellData() {
        }

        public int getCell(int x, int y, int z) {
            return ColumnNeighborhood.this.getLight(x, y, z, -1);
        }

        public int getCell(int x, int y, int z, int defaultValue) {
            return ColumnNeighborhood.this.getLight(x, y, z, defaultValue);
        }

        public int getCell(int x, int y, int z, Direction dir, int defaultValue) {
            Vec3i v = dir.getVec3i();
            return ColumnNeighborhood.this.getLight(v.x + x, v.y + y, v.z + z, defaultValue);
        }

        public void setCell(int x, int y, int z, int light) {
            ColumnNeighborhood.this.setLight(x, y, z, light);
        }
    }
}

