/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.TerrainImageId;
import com.simsilica.mworld.tile.TerrainImageType;
import com.simsilica.mworld.tile.Tile;
import com.simsilica.mworld.tile.TileFunction;
import mythruna.world.WorldFractal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FractalTerrainImageGenerator
implements TileFunction {
    static Logger log = LoggerFactory.getLogger(FractalTerrainImageGenerator.class);
    private int seaLevel = 128;
    private int treeLine = 500;
    private WorldFractal fractal;

    public FractalTerrainImageGenerator(WorldFractal fractal) {
        this.fractal = fractal;
    }

    public void accept(Tile tile) {
        TerrainImage terrain = (TerrainImage)tile.get((Object)TerrainImageType.Terrain, TerrainImage.class);
        TerrainImage fluid = (TerrainImage)tile.get((Object)TerrainImageType.Fluid, TerrainImage.class);
        if (terrain.getVersion().getLoadVersion() < 0L) {
            this.generateTerrain(terrain);
        }
        if (fluid.getVersion().getLoadVersion() < 0L) {
            int size = fluid.getSize();
            for (int x = 0; x < size; ++x) {
                for (int z = 0; z < size; ++z) {
                    short elev = terrain.getElevation(x, z);
                    if (elev < this.seaLevel) {
                        fluid.setElevation(x, z, (short)this.seaLevel);
                        fluid.setType(x, z, (byte)1);
                        continue;
                    }
                    fluid.setElevation(x, z, (short)this.seaLevel);
                    fluid.setType(x, z, (byte)-1);
                }
            }
            fluid.getVersion().markChanged();
        }
    }

    protected void generateTerrain(TerrainImage target) {
        TerrainImageId id = target.getId();
        Vec3i world = id.getTileId().getWorld(null);
        double xCorner = world.x;
        double zCorner = world.z;
        int scale = 1024 / id.getResolution().getSamples();
        short[] elevations = target.getElevations();
        byte[] types = target.getTypes();
        int size = target.getSize();
        boolean pos = false;
        for (int z = 0; z < size; ++z) {
            for (int x = 0; x < size; ++x) {
                double xp = xCorner + (double)(x * scale);
                double zp = zCorner + (double)(z * scale);
                double yp = this.fractal.getElevation(xp, zp);
                int elevation = (int)yp;
                target.setElevation(x, z, (short)elevation);
                int type = 0;
                int foliage = 0;
                int wetness = 0;
                int frozen = 0;
                if (elevation <= this.seaLevel) {
                    target.setType(x, z, (byte)0);
                    continue;
                }
                if (elevation >= this.treeLine) {
                    target.setType(x, z, (byte)-122);
                    continue;
                }
                double temperature = this.fractal.getTemperature(xp, yp, zp);
                if (temperature < 0.2) {
                    frozen = -128;
                }
                double weather = this.fractal.getWeather(xp, yp, zp);
                double ecology = this.fractal.getEcology(xp, yp, zp);
                double height = (double)(elevation - this.seaLevel) / (double)this.treeLine;
                double baselineHeight = 0.2;
                double heightEffect = (height - baselineHeight) / (1.0 - baselineHeight);
                double temperatureAdjust = heightEffect * 0.4;
                double climateAdjust = (temperature -= temperatureAdjust) - 0.5;
                double moist = weather - climateAdjust;
                if (moist < 0.2) {
                    type = 0;
                } else if (moist < 0.4) {
                    type = 1;
                } else {
                    type = 1;
                    foliage = 8;
                }
                target.setType(x, z, (byte)(type | foliage | wetness | frozen));
            }
        }
        target.getVersion().markChanged();
    }
}

