/*
 * Copyright (c) 2022, Simsilica, LLC
 * All rights reserved.
 */

import org.slf4j.*;
//import org.apache.log4j.Category;
//import org.apache.log4j.NDC;
// I don't know why those fail.
import com.simsilica.action.*;
import com.simsilica.mod.*;
import com.simsilica.mworld.World;
import com.simsilica.ext.mblock.*;
import mythruna.GameConstants;
import mythruna.sim.Activator;
import mythruna.world.WorldManager;
import mythruna.net.server.GameSessionHostedService.ActivatorImpl;

// Define access to the services
system = { Class type ->
    return gameSystems.get(type, true);
}

optionalSystem = { Class type ->
    return gameSystems.get(type);
}

entityData = system(EntityData);
world = system(World)

findEntities = { ComponentFilter filter, Class... types ->
    return entityData.findEntities(filter, types);
}

createEntity = { EntityComponent... init ->
    def result = entityData.createEntity();
    entityData.setComponents(result, init);
    return result; 
}

removeEntity = { EntityId id ->
    entityData.removeEntity(id);
}

worldManager = optionalSystem(WorldManager);
if( worldManager ) {
    //stringToCellArray =  CellArrayFunctions.cellArrayStorage(worldManager.getCellArrayStorage());
    stringToCellArray = CellArrayFunctions.chain(
                            CellArrayFunctions.cellArrayStorage(worldManager.getCellArrayStorage()),
                            CellArrayFunctions.blocksResource(),
                            );
}

loadCells = { ShapeInfo shape ->
    def shapeName = shape.getShapeName(entityData);
    return stringToCellArray.apply(shapeName);
}

// Convenience method for resolving an object to its EntityId wherever
// that is needed.
resolveEntityId = { Object o ->
    if( o == null ) {
        return null;
    } else if( o instanceof EntityId ) {
        return (EntityId)o;
    } else if( o instanceof Activator ) {
        return ((Activator)o).id;
    } else if( o instanceof ActionContext ) {
        return ((ActionContext)o).target;
    }
    throw new IllegalArgumentException("Object cannot be resolved to EntityId:" + o);
}


createBlueprintFromCells = { EntityId parent, String bpName, String objectName, CellArray cells, boolean carved, double scale ->

    // See if there is already an entity for the bpName
    ComponentFilter<BlueprintInfo> filter1 = Filters.fieldEquals(BlueprintInfo.class, "parent", parent);
    ComponentFilter<BlueprintInfo> filter2 = Filters.fieldEquals(BlueprintInfo.class, "name", bpName);
    ComponentFilter<BlueprintInfo> filter = Filters.and(BlueprintInfo.class, filter1, filter2);
    EntityId entity = entityData.findEntity(filter, BlueprintInfo.class);
    if( entity == null ) {
        entity = entityData.createEntity();
        log.info("Creating blueprint for:" + bpName);
    } else {
        BlueprintInfo bpInfo = entityData.getComponent(entity, BlueprintInfo.class); 
        log.info("Found existing blueprint for:" + bpName + " : " + bpInfo);
    }

    CellArrayId cellId = worldManager.getCellArrayStorage().store(cells);
    
    Vec3i offset = new Vec3i();
    offset.x = 5 - (cells.getSizeX()/2);
    offset.z = 5 - (cells.getSizeZ()/2);

    String shapeName = cellId.toFileName();
    if( carved ) {
        shapeName = "c_" + shapeName;
    }

    log.info("createing shapeId:" + shapeName);
    entityData.setComponents(entity,
            new BlueprintInfo(parent, bpName, offset),
            ObjectName.create(objectName, entityData),
            ShapeInfo.create(shapeName, scale, entityData),
            new CreatedBy(parent) 
            );

    return entity;                
}    
  
    
