/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.net;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Name;
import com.simsilica.ext.mphys.SpawnPosition;
import com.simsilica.lemur.RangedValueModel;
import com.simsilica.lemur.core.VersionedObject;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.config.MaterialRegistry;
import com.simsilica.mworld.LeafId;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.World;
import com.simsilica.mworld.tile.Resolution;
import com.simsilica.mworld.tile.TerrainImageType;
import com.simsilica.thread.Job;
import com.simsilica.thread.WorkerPool;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import mythruna.client.MythrunaConfig;
import mythruna.client.ProgressState;
import mythruna.client.net.ConnectionState;
import mythruna.net.AccountSession;
import mythruna.world.es.WorldAge;
import mythruna.world.es.WorldSeed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorldPreloader
implements Job {
    static Logger log = LoggerFactory.getLogger(WorldPreloader.class);
    private ConnectionState connection;
    private ProgressState.ProgressTracker tracker;
    private AccountSession account;
    private EntityData ed;
    private World world;
    private Consumer<Exception> onDone;
    private int poolSize;
    private int leafRadius;
    private int tileRadius;
    private Exception error;
    private ProgressModel progress = new ProgressModel(100);
    private SpawnPosition playerPosition;
    private EntityId characterId;
    private EntityId worldEntity;
    private WorldAge worldAge;
    private WorldSeed worldSeed;
    private String worldName;
    private Map<String, Material> materials;
    private List<Object> loaded = Collections.synchronizedList(new ArrayList());

    public WorldPreloader(EntityId characterId, ConnectionState connection, ProgressState.ProgressTracker tracker) {
        this.characterId = characterId;
        this.connection = connection;
        this.tracker = tracker;
        this.tracker.setValue(this.progress);
        this.ed = connection.getEntityData();
        this.world = connection.getService(World.class);
        this.account = connection.getService(AccountSession.class);
        MythrunaConfig config = MythrunaConfig.getInstance();
        this.leafRadius = config.getStartupSettingInt("WorldPreloader.leafRadius", 2);
        this.tileRadius = config.getStartupSettingInt("WorldPreloader.tileRadius", 1);
        this.poolSize = config.getStartupSettingInt("WorldPreloader.poolSize", 16);
        log.info("Using leafRadius:" + this.leafRadius + "  tileRadius:" + this.tileRadius + "  poolSize:" + this.poolSize);
        tracker.setSplash("Splash/loading1.jpg");
    }

    public SpawnPosition getPlayerStart() {
        return this.playerPosition;
    }

    public WorldAge getWorldAge() {
        return this.worldAge;
    }

    public WorldSeed getWorldSeed() {
        return this.worldSeed;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public Map<String, Material> getMaterials() {
        return this.materials;
    }

    public void release() {
        this.loaded.clear();
    }

    public WorldPreloader onDone(Consumer<Exception> onDone) {
        this.onDone = onDone;
        return this;
    }

    protected void resourceSetup() {
        long start = System.nanoTime();
        try {
            InputStream in = this.getClass().getResourceAsStream("/materials.mset");
            if (in == null) {
                throw new RuntimeException("Resource /materials.mset not found");
            }
            this.materials = MaterialRegistry.loadCompiledMaterials((AssetManager)this.connection.getApplication().getAssetManager(), (InputStream)in);
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading /materials.mset", e);
        }
        finally {
            long end = System.nanoTime();
            log.info("Read materials.mset in " + (double)(end - start) / 1000000.0 + " ms");
        }
    }

    public void runOnWorker() {
        int z;
        int x;
        try {
            this.account.enterWorld(this.characterId);
        }
        catch (Exception e) {
            log.error("Error entering world", (Throwable)e);
            this.error = e;
            return;
        }
        int components = 6;
        int yLeafSize = 1 + (this.leafRadius + 1) * 2;
        int xzLeafSize = 1 + this.leafRadius * 2;
        int tileSize = 1 + this.tileRadius * 2;
        int total = components + xzLeafSize * xzLeafSize * yLeafSize + tileSize * tileSize;
        this.progress.setMaximum(total);
        this.resourceSetup();
        this.progress.increment();
        this.worldEntity = this.account.getWorldEntity();
        this.progress.increment();
        this.worldAge = (WorldAge)this.ed.getComponent(this.worldEntity, WorldAge.class);
        this.progress.increment();
        this.worldSeed = (WorldSeed)this.ed.getComponent(this.worldEntity, WorldSeed.class);
        this.progress.increment();
        Name name = (Name)this.ed.getComponent(this.worldEntity, Name.class);
        this.worldName = name.getName();
        this.progress.increment();
        this.playerPosition = (SpawnPosition)this.ed.getComponent(this.characterId, SpawnPosition.class);
        this.progress.increment();
        log.info("player location:" + this.playerPosition);
        if (this.playerPosition == null) {
            log.error("Player has no spawn position:" + this.characterId);
            this.error = new RuntimeException("Player has no spawn position");
            return;
        }
        WorkerPool loaders = new WorkerPool(this.poolSize);
        Vec3i center = this.playerPosition.getLocation().floor();
        HashSet<TileId> tiles = new HashSet<TileId>();
        int radius = this.leafRadius;
        int yRadius = radius + 1;
        for (x = -radius; x <= radius; ++x) {
            for (z = -radius; z <= radius; ++z) {
                for (int y = -yRadius; y <= yRadius; ++y) {
                    Vec3i loc = center.add(x * 32, y * 32, z * 32);
                    if (loc.y < 0) continue;
                    final LeafId leafId = LeafId.fromWorld((Vec3i)loc);
                    tiles.add(leafId.getColumnId().getTileId());
                    loaders.execute(new Job(){

                        public void runOnWorker() {
                            log.info("Loading leaf data for:" + leafId);
                            WorldPreloader.this.loaded.add(WorldPreloader.this.world.getLeaf(leafId));
                            WorldPreloader.this.loaded.add(WorldPreloader.this.world.getLight(leafId));
                            WorldPreloader.this.loaded.add(WorldPreloader.this.world.getFluid(leafId));
                            WorldPreloader.this.progress.increment();
                        }

                        public double runOnUpdate() {
                            return 0.0;
                        }
                    });
                }
            }
        }
        for (x = -this.tileRadius; x <= this.tileRadius; ++x) {
            for (z = -this.tileRadius; z <= this.tileRadius; ++z) {
                TileId tileId = TileId.fromWorld((Vec3i)center.add(x * 1024, 0, z * 1024));
                tiles.add(tileId);
            }
        }
        for (final TileId tileId : tiles) {
            loaders.execute(new Job(){

                public void runOnWorker() {
                    log.info("Loading far terrain for:" + tileId);
                    WorldPreloader.this.loaded.add(WorldPreloader.this.world.getTerrainImage(tileId, TerrainImageType.Terrain, Resolution.High));
                    log.info("Loading far fluid for:" + tileId);
                    WorldPreloader.this.loaded.add(WorldPreloader.this.world.getTerrainImage(tileId, TerrainImageType.Fluid, Resolution.High));
                    log.info("Loading trees for:" + tileId);
                    WorldPreloader.this.loaded.add(WorldPreloader.this.world.getTrees(tileId, null));
                    WorldPreloader.this.progress.increment();
                }

                public double runOnUpdate() {
                    return 0.0;
                }
            });
        }
        while (loaders.getQueuedJobCount() + loaders.getActiveJobCount() > 0) {
            loaders.update(Double.POSITIVE_INFINITY);
            log.info("Waiting another second...");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                log.error("Interrupted sleeping", (Throwable)e);
                break;
            }
        }
        log.info("Preload workers done, shutting them down...");
        loaders.shutdownNow(true);
    }

    public double runOnUpdate() {
        if (this.onDone != null) {
            this.onDone.accept(this.error);
        }
        return 0.0;
    }

    private class ProgressModel
    implements RangedValueModel {
        private AtomicInteger progress = new AtomicInteger(0);
        private int total;

        public ProgressModel(int total) {
            this.total = total;
        }

        public void increment() {
            this.progress.incrementAndGet();
        }

        public Double getObject() {
            return this.getValue();
        }

        public long getVersion() {
            return this.progress.get();
        }

        public VersionedReference<Double> createReference() {
            return new VersionedReference((VersionedObject)this);
        }

        public void setValue(double val) {
            throw new UnsupportedOperationException();
        }

        public double getValue() {
            return this.progress.get();
        }

        public void setPercent(double val) {
            throw new UnsupportedOperationException();
        }

        public double getPercent() {
            return this.getValue() / (double)this.total;
        }

        public void setMaximum(double max) {
            this.total = (int)max;
        }

        public double getMaximum() {
            return this.total;
        }

        public void setMinimum(double min) {
            throw new UnsupportedOperationException();
        }

        public double getMinimum() {
            return 0.0;
        }
    }
}

