/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.crig.sim;

import com.simsilica.crig.CharacterRig;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnimPump {
    static Logger log = LoggerFactory.getLogger(AnimPump.class);
    private CharacterRig rig;
    private String layer;
    private String action;
    private double time;
    private double speed;
    private double length;

    public AnimPump(CharacterRig rig, String layer) {
        this.rig = rig;
        this.layer = layer;
    }

    public void setCurrentAction(String action, double speed) {
        this.speed = speed;
        if (Objects.equals(this.action, action)) {
            return;
        }
        this.time = 0.0;
        this.action = action;
        if (action != null) {
            log.info("setLayerAction(" + this.layer + ", " + action + ")");
            this.rig.setLayerAction(this.layer, action);
            this.length = this.rig.getLayerDuration(this.layer);
            log.info("duration:" + this.length);
        }
    }

    public String getCurrentAction() {
        return this.action;
    }

    public void setTime(double time) {
        this.time = time;
        this.update(0.0);
    }

    public double getTime() {
        return this.time;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    public double getSpeed() {
        return this.speed;
    }

    public void update(double tpf) {
        if (this.action == null) {
            return;
        }
        this.time += tpf * this.speed;
        this.time %= this.length;
        if (this.time < 0.0) {
            this.time = (this.time + this.length) % this.length;
        }
        this.rig.setTime(this.layer, this.time);
    }
}

