/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.transaction;

import com.simsilica.mworld.CellChangeEvent;
import com.simsilica.mworld.DataType;
import com.simsilica.mworld.LeafId;
import com.simsilica.mworld.transaction.CellEdit;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeafTransaction {
    static Logger log = LoggerFactory.getLogger(LeafTransaction.class);
    private static final CellEdit[] EMPTY_ARRAY = new CellEdit[0];
    private LeafId leafId;
    private List<CellEdit> blockChanges = new ArrayList<CellEdit>();
    private List<CellEdit> lightChanges = new ArrayList<CellEdit>();
    private List<CellEdit> fluidChanges = new ArrayList<CellEdit>();

    public LeafTransaction(LeafId leafId) {
        this.leafId = leafId;
    }

    public CellChangeEvent createCellChangeEvent() {
        CellEdit[] blocks = this.blockChanges.isEmpty() ? null : this.blockChanges.toArray(EMPTY_ARRAY);
        CellEdit[] lights = this.lightChanges.isEmpty() ? null : this.lightChanges.toArray(EMPTY_ARRAY);
        CellEdit[] fluids = this.fluidChanges.isEmpty() ? null : this.fluidChanges.toArray(EMPTY_ARRAY);
        return new CellChangeEvent(this.leafId, blocks, lights, fluids);
    }

    public void cellChanged(DataType type, int i, int j, int k, int value, int oldValue) {
        CellEdit edit = new CellEdit((byte)i, (byte)j, (byte)k, value, oldValue);
        switch (type) {
            case Block: {
                this.blockChanges.add(edit);
                break;
            }
            case Light: {
                this.lightChanges.add(edit);
                break;
            }
            case Fluid: {
                this.fluidChanges.add(edit);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Type not yet supported:" + (Object)((Object)type));
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[leafId:" + this.leafId + ", #blockChanges:" + this.blockChanges.size() + ", #lightChanges:" + this.lightChanges.size() + ", #fluidChanges:" + this.fluidChanges.size() + "]";
    }
}

