/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim.ai;

import com.simsilica.es.EntityId;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.phys.MBlockShape;
import com.simsilica.mphys.RigidBody;
import mythruna.sim.ai.AgentMovementInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RigidBodyMover {
    static Logger log = LoggerFactory.getLogger(RigidBodyMover.class);
    private static final double HALF_PI = 1.5707963267948966;
    private static final double TWO_PI = Math.PI * 2;
    private RigidBody<EntityId, MBlockShape> body;
    private double yaw;
    private double pitch;
    private double averageYaw;
    private int windowSize = 5;
    private double yawSpeed = Math.PI * 2;
    private double pitchSpeed = Math.PI * 2;
    private Vec3d targetVelocity = new Vec3d();
    private double maxSpeed = 2.0;
    private Vec3d force = new Vec3d();

    public RigidBodyMover(RigidBody<EntityId, MBlockShape> body) {
        this.body = body;
        double[] angles = body.orientation.toAngles(null);
        this.yaw = angles[1];
        this.pitch = 0.0;
    }

    private double wrap(double val, double min, double max) {
        if (val < min) {
            val += max - min;
        } else if (val > max) {
            val -= max - min;
        }
        return val;
    }

    public void steer(AgentMovementInput input, Vec3d actualVelocity, boolean onGround, double step) {
        this.yaw += input.move.x * this.yawSpeed * step;
        this.yaw = this.wrap(this.yaw, 0.0, Math.PI * 2);
        this.pitch += input.move.y * this.pitchSpeed * step;
        this.pitch = this.wrap(this.pitch, -1.5707963267948966, 1.5707963267948966);
        this.averageYaw = this.yaw;
        this.body.orientation.fromAngles(this.pitch, this.averageYaw, 0.0);
        this.body.setRotationalVelocity(0.0, 0.0, 0.0);
        this.targetVelocity.set(0.0, 0.0, this.maxSpeed * input.move.z);
        if (this.targetVelocity.lengthSq() > 0.0) {
            this.body.orientation.mult(this.targetVelocity, this.targetVelocity);
        }
        this.force.set(this.targetVelocity).subtractLocal(actualVelocity);
        this.force.y = 0.0;
        if (this.force.lengthSq() > 1.0E-4) {
            this.force.normalizeLocal().multLocal(100.0);
            this.body.addForce(this.force);
        }
    }
}

