/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.event;

import com.jme3.app.Application;
import com.jme3.input.RawInputListener;
import com.jme3.input.event.TouchEvent;
import com.simsilica.lemur.event.BasePickState;
import com.simsilica.lemur.event.DefaultRawInputListener;
import com.simsilica.lemur.event.PickEventSession;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class TouchAppState
extends BasePickState {
    private static final Logger logger = Logger.getLogger(TouchAppState.class.getName());
    private TouchObserver touchObserver = new TouchObserver();
    protected Map<Integer, PointerData> pointerDataMap = new HashMap<Integer, PointerData>();

    public TouchAppState(Application app) {
        this.setEnabled(true);
        app.getInputManager().addRawInputListener((RawInputListener)this.touchObserver);
    }

    @Override
    protected void cleanup(Application app) {
        app.getInputManager().removeRawInputListener((RawInputListener)this.touchObserver);
        this.pointerDataMap.clear();
    }

    @Override
    protected void dispatchMotion() {
        if (this.pointerDataMap.isEmpty()) {
            return;
        }
        for (Map.Entry<Integer, PointerData> entry : this.pointerDataMap.entrySet()) {
            PointerData pointerData = entry.getValue();
            pointerData.session.cursorMoved(pointerData.lastX, pointerData.lastY);
        }
    }

    protected boolean dispatchButton(PointerData pointerData, boolean pressed) {
        boolean buttonConsumed = pointerData.session.buttonEvent(0, pointerData.lastX, pointerData.lastY, pressed);
        if (buttonConsumed && !pressed) {
            pointerData.session.clearHitTarget();
        }
        return buttonConsumed;
    }

    protected PointerData getPointerData(int pointerId, int x, int y) {
        PointerData pointerData;
        if (this.pointerDataMap.isEmpty()) {
            pointerData = new PointerData(pointerId, this.getSession(), x, y);
        } else if (!this.pointerDataMap.containsKey(pointerId)) {
            pointerData = new PointerData(pointerId, this.getSession().clone(), x, y);
        } else {
            pointerData = this.pointerDataMap.get(pointerId);
            pointerData.lastX = x;
            pointerData.lastY = y;
        }
        this.pointerDataMap.put(pointerId, pointerData);
        return pointerData;
    }

    protected class TouchObserver
    extends DefaultRawInputListener {
        protected TouchObserver() {
        }

        @Override
        public void onTouchEvent(TouchEvent te) {
            if (!TouchAppState.this.isEnabled()) {
                return;
            }
            switch (te.getType()) {
                case DOWN: {
                    PointerData pointerData = TouchAppState.this.getPointerData(te.getPointerId(), (int)te.getX(), (int)te.getY());
                    if (!TouchAppState.this.dispatchButton(pointerData, true)) break;
                    te.setConsumed();
                    break;
                }
                case MOVE: {
                    PointerData pointerData = TouchAppState.this.pointerDataMap.get(te.getPointerId());
                    if (pointerData == null) break;
                    pointerData.lastX = (int)te.getX();
                    pointerData.lastY = (int)te.getY();
                    break;
                }
                case UP: {
                    PointerData pointerData = TouchAppState.this.pointerDataMap.get(te.getPointerId());
                    if (pointerData == null) break;
                    pointerData.lastX = (int)te.getX();
                    pointerData.lastY = (int)te.getY();
                    if (TouchAppState.this.dispatchButton(pointerData, false)) {
                        te.setConsumed();
                    }
                    TouchAppState.this.pointerDataMap.remove(te.getPointerId());
                    break;
                }
            }
        }
    }

    protected class PointerData {
        private int pointerId;
        private PickEventSession session;
        private int lastX;
        private int lastY;

        protected PointerData(int pointerId, PickEventSession session, int lastX, int lastY) {
            this.pointerId = pointerId;
            this.session = session;
            this.lastX = lastX;
            this.lastY = lastY;
        }
    }
}

