/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.base;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.Direction;
import com.simsilica.mworld.LeafData;
import com.simsilica.mworld.LeafId;
import com.simsilica.mworld.World;

public class LocalCellData
implements CellData {
    private World world;
    private LeafData center;
    private CellArray cells;
    private LeafData[] neighbors = new LeafData[6];

    public LocalCellData(LeafData center, World world) {
        this.world = world;
        this.center = center;
        this.cells = center.getRawCells();
    }

    public LocalCellData(LeafData center, LeafData[] neighbors) {
        this.neighbors = neighbors;
        this.center = center;
        this.cells = center.getRawCells();
    }

    public LeafData[] getNeighbors() {
        return this.neighbors;
    }

    private CellArray getNeighbor(Direction dir) {
        int ord = dir.ordinal();
        LeafData result = this.neighbors[ord];
        if (result == null) {
            LeafId leafId = LeafId.fromWorld(this.center.getInfo().location);
            result = this.world.getLeaf(leafId);
        }
        return result.getRawCells();
    }

    public int getCell(int x, int y, int z) {
        if (x < 0) {
            return this.getNeighbor(Direction.West).getCell(x + this.cells.getSizeX(), y, z);
        }
        if (y < 0) {
            return this.getNeighbor(Direction.Down).getCell(x, y + this.cells.getSizeY(), z);
        }
        if (z < 0) {
            return this.getNeighbor(Direction.North).getCell(x, y, z + this.cells.getSizeZ());
        }
        if (x >= this.cells.getSizeX()) {
            return this.getNeighbor(Direction.East).getCell(x - this.cells.getSizeX(), y, z);
        }
        if (y >= this.cells.getSizeY()) {
            return this.getNeighbor(Direction.Up).getCell(x, y - this.cells.getSizeY(), z);
        }
        if (z >= this.cells.getSizeZ()) {
            return this.getNeighbor(Direction.South).getCell(x, y, z - this.cells.getSizeZ());
        }
        return this.cells.getCell(x, y, z);
    }

    public int getCell(int x, int y, int z, int defaultValue) {
        if (x < 0) {
            return this.getNeighbor(Direction.West).getCell(x + this.cells.getSizeX(), y, z, defaultValue);
        }
        if (y < 0) {
            return this.getNeighbor(Direction.Down).getCell(x, y + this.cells.getSizeY(), z, defaultValue);
        }
        if (z < 0) {
            return this.getNeighbor(Direction.North).getCell(x, y, z + this.cells.getSizeZ(), defaultValue);
        }
        if (x >= this.cells.getSizeX()) {
            return this.getNeighbor(Direction.East).getCell(x - this.cells.getSizeX(), y, z, defaultValue);
        }
        if (y >= this.cells.getSizeY()) {
            return this.getNeighbor(Direction.Up).getCell(x, y - this.cells.getSizeY(), z, defaultValue);
        }
        if (z >= this.cells.getSizeZ()) {
            return this.getNeighbor(Direction.South).getCell(x, y, z - this.cells.getSizeZ(), defaultValue);
        }
        return this.cells.getCell(x, y, z, defaultValue);
    }

    public int getCell(int x, int y, int z, Direction dir, int defaultValue) {
        Vec3i v = dir.getVec3i();
        return this.getCell(x + v.x, y + v.y, z + v.z, defaultValue);
    }

    public void setCell(int x, int y, int z, int type) {
        if (x < 0) {
            this.getNeighbor(Direction.West).setCell(x + this.cells.getSizeX(), y, z, type);
        } else if (y < 0) {
            this.getNeighbor(Direction.Down).setCell(x, y + this.cells.getSizeY(), z, type);
        } else if (z < 0) {
            this.getNeighbor(Direction.North).setCell(x, y, z + this.cells.getSizeZ(), type);
        } else if (x >= this.cells.getSizeX()) {
            this.getNeighbor(Direction.East).setCell(x - this.cells.getSizeX(), y, z, type);
        } else if (y >= this.cells.getSizeY()) {
            this.getNeighbor(Direction.Up).setCell(x, y - this.cells.getSizeY(), z, type);
        } else if (z >= this.cells.getSizeZ()) {
            this.getNeighbor(Direction.South).setCell(x, y, z - this.cells.getSizeZ(), type);
        }
        this.cells.setCell(x, y, z, type);
    }
}

